/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class UnderlayBrush
extends PerformBrush {
    private static final int DEFAULT_DEPTH = 3;
    private int depth = 3;

    public UnderlayBrush() {
        this.setName("Underlay (Reverse Overlay)");
    }

    private void underlay(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        double brushSizeSquared = brushSize * brushSize;
        int minx = GenericMath.floor((double)((double)targetBlock.getBlockX() - brushSize));
        int maxx = GenericMath.floor((double)((double)targetBlock.getBlockX() + brushSize)) + 1;
        int minz = GenericMath.floor((double)((double)targetBlock.getBlockZ() - brushSize));
        int maxz = GenericMath.floor((double)((double)targetBlock.getBlockZ() + brushSize)) + 1;
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * (brushSize + 1.0) * (brushSize + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            double xs = (minx - x) * (minx - x);
            for (int z = minz; z <= maxz; ++z) {
                int y;
                double zs = (minz - z) * (minz - z);
                if (!(xs + zs < brushSizeSquared)) continue;
                for (y = targetBlock.getBlockY(); y <= Brush.WORLD_HEIGHT && this.world.getBlockType(x, y, z) == BlockTypes.AIR; ++y) {
                }
                if (y == targetBlock.getBlockY() && y > 0 && this.world.getBlockType(x, y - 1, z) != BlockTypes.AIR) continue;
                for (int y0 = y; y0 < y + this.depth; ++y0) {
                    if (this.world.getBlockType(x, y0, z) == BlockTypes.AIR) continue;
                    this.perform(v, x, y0, z);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    public final void arrow(SnipeData v) {
        this.underlay(v, (Location<World>)this.targetBlock);
    }

    @Override
    public final void powder(SnipeData v) {
        this.underlay(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par.length < 0) {
            v.sendMessage(TextColors.AQUA, "Usage: /b reover d[#]");
            return;
        }
        if (par[0].equalsIgnoreCase("info")) {
            v.sendMessage(TextColors.GOLD, "Reverse Overlay brush parameters:");
            v.sendMessage(TextColors.AQUA, "d[number] (ex: d3) The number of blocks thick to change.");
            return;
        }
        if (par[0].startsWith("d")) {
            this.depth = Integer.parseInt(par[0].replace("d", ""));
            if (this.depth < 1) {
                this.depth = 1;
            }
            v.sendMessage(TextColors.AQUA, "Depth set to " + this.depth);
        } else {
            v.sendMessage(TextColors.RED, "Invalid parameter '" + par[0] + "'");
            v.sendMessage(TextColors.AQUA, "Usage: /b reover d[#]");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.underlay";
    }
}

