/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class VoxelBrush
extends PerformBrush {
    public VoxelBrush() {
        this.setName("Voxel");
    }

    private void voxel(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        int minx = (int)Math.round((double)targetBlock.getBlockX() - brushSize);
        int maxx = (int)Math.round((double)targetBlock.getBlockX() + brushSize);
        int miny = Math.max((int)Math.round((double)targetBlock.getBlockY() - brushSize), 0);
        int maxy = Math.min((int)Math.round((double)targetBlock.getBlockY() + brushSize), WORLD_HEIGHT);
        int minz = (int)Math.round((double)targetBlock.getBlockZ() - brushSize);
        int maxz = (int)Math.round((double)targetBlock.getBlockZ() + brushSize);
        this.undo = new Undo(GenericMath.floor((double)(8.0 * (brushSize + 1.0) * (brushSize + 1.0) * (brushSize + 1.0))));
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                for (int z = minz; z <= maxz; ++z) {
                    this.perform(v, x, y, z);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.voxel(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.voxel(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.voxel";
    }
}

