/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.shape;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class VoxelDiscBrush
extends PerformBrush {
    public VoxelDiscBrush() {
        this.setName("Voxel Disc");
    }

    private void disc(SnipeData v, Location<World> targetBlock) {
        double brushSize = v.getBrushSize();
        int minx = (int)Math.round((double)targetBlock.getBlockX() - brushSize);
        int maxx = (int)Math.round((double)targetBlock.getBlockX() + brushSize);
        int minz = (int)Math.round((double)targetBlock.getBlockZ() - brushSize);
        int maxz = (int)Math.round((double)targetBlock.getBlockZ() + brushSize);
        this.undo = new Undo(GenericMath.floor((double)(4.0 * brushSize * brushSize)));
        for (int x = minx; x <= maxx; ++x) {
            for (int z = minz; z <= maxz; ++z) {
                this.perform(v, x, targetBlock.getBlockY(), z);
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.disc(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.disc(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.voxeldisc";
    }
}

