/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.terrain;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Maps;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.terrain.BlendBrushBase;
import com.thevoxelbox.voxelsniper.util.BlockBuffer;
import java.util.HashMap;
import org.spongepowered.api.block.BlockState;

public class BlendDiscBrush
extends BlendBrushBase {
    public BlendDiscBrush() {
        this.setName("Blend Disc");
    }

    @Override
    protected final void blend(SnipeData v) {
        int z0;
        int z;
        int x0;
        int x;
        int brushSize = (int)v.getBrushSize() + 1;
        double brushSizeSquared = v.getBrushSize() * v.getBrushSize();
        BlockBuffer buffer = new BlockBuffer(new Vector3i(-brushSize, 0, -brushSize), new Vector3i(brushSize, 0, brushSize));
        int tx = this.targetBlock.getBlockX();
        int ty = this.targetBlock.getBlockY();
        int tz = this.targetBlock.getBlockZ();
        HashMap frequency = Maps.newHashMap();
        for (x = -brushSize; x <= brushSize; ++x) {
            x0 = x + tx;
            for (z = -brushSize; z <= brushSize; ++z) {
                BlockState currentState;
                if ((double)(x * x + z * z) >= brushSizeSquared) continue;
                z0 = z + tz;
                int highest = 1;
                BlockState highestState = currentState = this.world.getBlock(x0, ty, z0);
                frequency.clear();
                boolean tie = false;
                for (int ox = -1; ox <= 1; ++ox) {
                    for (int oz = -1; oz <= 1; ++oz) {
                        BlockState state = this.world.getBlock(x0 + ox, ty, z0 + oz);
                        Integer count = (Integer)frequency.get(state);
                        if (count == null) {
                            count = 1;
                        } else {
                            Integer n = count;
                            Integer n2 = count = Integer.valueOf(count + 1);
                        }
                        if (count > highest) {
                            highest = count;
                            highestState = state;
                            tie = false;
                        } else if (count == highest) {
                            tie = true;
                        }
                        frequency.put(state, count);
                    }
                }
                if (tie || currentState == highestState) continue;
                buffer.set(x, 0, z, highestState);
            }
        }
        this.undo = new Undo(buffer.getBlockCount());
        for (x = -brushSize; x <= brushSize; ++x) {
            x0 = x + tx;
            for (z = -brushSize; z <= brushSize; ++z) {
                z0 = z + tz;
                if (!buffer.contains(x, 0, z)) continue;
                this.setBlockState(x0, ty, z0, buffer.get(x, ty, z));
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.blenddisc";
    }
}

