/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.terrain;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Maps;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.terrain.BlendBrushBase;
import com.thevoxelbox.voxelsniper.util.BlockBuffer;
import java.util.HashMap;
import org.spongepowered.api.block.BlockState;

public class BlendVoxelBrush
extends BlendBrushBase {
    public BlendVoxelBrush() {
        this.setName("Blend Voxel");
    }

    @Override
    protected final void blend(SnipeData v) {
        int z0;
        int z;
        int y0;
        int y;
        int x0;
        int x;
        int brushSize = (int)Math.round(v.getBrushSize());
        BlockBuffer buffer = new BlockBuffer(new Vector3i(-brushSize, -brushSize, -brushSize), new Vector3i(brushSize, brushSize, brushSize));
        int tx = this.targetBlock.getBlockX();
        int ty = this.targetBlock.getBlockY();
        int tz = this.targetBlock.getBlockZ();
        HashMap frequency = Maps.newHashMap();
        for (x = -brushSize; x <= brushSize; ++x) {
            x0 = x + tx;
            for (y = -brushSize; y <= brushSize; ++y) {
                y0 = y + ty;
                for (z = -brushSize; z <= brushSize; ++z) {
                    BlockState currentState;
                    z0 = z + tz;
                    int highest = 1;
                    BlockState highestState = currentState = this.world.getBlock(x0, y0, z0);
                    frequency.clear();
                    boolean tie = false;
                    for (int ox = -1; ox <= 1; ++ox) {
                        for (int oz = -1; oz <= 1; ++oz) {
                            for (int oy = -1; oy <= 1; ++oy) {
                                if (oy + y0 < 0 || oy + y0 > WORLD_HEIGHT) continue;
                                BlockState state = this.world.getBlock(x0 + ox, y0 + oy, z0 + oz);
                                Integer count = (Integer)frequency.get(state);
                                if (count == null) {
                                    count = 1;
                                } else {
                                    Integer n = count;
                                    Integer n2 = count = Integer.valueOf(count + 1);
                                }
                                if (count > highest) {
                                    highest = count;
                                    highestState = state;
                                    tie = false;
                                } else if (count == highest) {
                                    tie = true;
                                }
                                frequency.put(state, count);
                            }
                        }
                    }
                    if (tie || currentState == highestState) continue;
                    buffer.set(x, y, z, highestState);
                }
            }
        }
        this.undo = new Undo(buffer.getBlockCount());
        for (x = -brushSize; x <= brushSize; ++x) {
            x0 = x + tx;
            for (y = -brushSize; y <= brushSize; ++y) {
                y0 = y + ty;
                for (z = -brushSize; z <= brushSize; ++z) {
                    z0 = z + tz;
                    if (!buffer.contains(x, y, z)) continue;
                    this.setBlockState(x0, y0, z0, buffer.get(x, y, z));
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.blendvoxel";
    }
}

