/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.terrain;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.util.BlockBuffer;
import com.thevoxelbox.voxelsniper.util.BlockHelper;
import java.util.HashMap;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class ErodeBrush
extends Brush {
    private static final Vector3i[] FACES_TO_CHECK = new Vector3i[]{new Vector3i(0, -1, 0), new Vector3i(0, 1, 0), new Vector3i(0, 0, 1), new Vector3i(0, 0, -1), new Vector3i(1, 0, 0), new Vector3i(-1, 0, 0)};
    private ErosionParameters currentPreset = Preset.MELT.getParameters();

    public ErodeBrush() {
        this.setName("Erode");
    }

    protected void erosion(SnipeData v, int erodeFaces, int erodeRec, int fillFaces, int fillRec) {
        int i;
        int brushSize = (int)Math.ceil(v.getBrushSize());
        double brushSizeSquared = v.getBrushSize() * v.getBrushSize();
        int tx = this.targetBlock.getBlockX();
        int ty = this.targetBlock.getBlockY();
        int tz = this.targetBlock.getBlockZ();
        BlockBuffer buffer1 = new BlockBuffer(new Vector3i(-brushSize - 1, -brushSize - 1, -brushSize - 1), new Vector3i(brushSize + 1, brushSize + 1, brushSize + 1));
        BlockBuffer buffer2 = new BlockBuffer(new Vector3i(-brushSize - 1, -brushSize - 1, -brushSize - 1), new Vector3i(brushSize + 1, brushSize + 1, brushSize + 1));
        for (int x = -brushSize - 1; x <= brushSize + 1; ++x) {
            int x0 = x + tx;
            for (int y = -brushSize - 1; y <= brushSize + 1; ++y) {
                int y0 = y + ty;
                for (int z = -brushSize - 1; z <= brushSize + 1; ++z) {
                    int z0 = z + tz;
                    BlockState state = this.world.getBlock(x0, y0, z0);
                    buffer1.set(x, y, z, state);
                    buffer2.set(x, y, z, state);
                }
            }
        }
        int swap = 0;
        for (i = 0; i < erodeRec; ++i) {
            this.erosionIteration(v, erodeFaces, swap % 2 == 0 ? buffer1 : buffer2, swap % 2 == 1 ? buffer1 : buffer2);
            ++swap;
        }
        for (i = 0; i < fillRec; ++i) {
            this.fillIteration(v, fillFaces, swap % 2 == 0 ? buffer1 : buffer2, swap % 2 == 1 ? buffer1 : buffer2);
            ++swap;
        }
        BlockBuffer finalBuffer = swap % 2 == 0 ? buffer1 : buffer2;
        this.undo = new Undo(finalBuffer.getBlockCount());
        for (int x = -brushSize; x <= brushSize; ++x) {
            int x0 = x + tx;
            for (int y = -brushSize; y <= brushSize; ++y) {
                int y0 = y + ty;
                for (int z = -brushSize; z <= brushSize; ++z) {
                    int z0 = z + tz;
                    if (!((double)(x * x + y * y + z * z) <= brushSizeSquared) || !finalBuffer.contains(x, y, z)) continue;
                    this.setBlockState(x0, y0, z0, finalBuffer.get(x, y, z));
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    private void fillIteration(SnipeData v, int fillFaces, BlockBuffer current, BlockBuffer target) {
        int brushSize = (int)v.getBrushSize() + 1;
        double brushSizeSquared = v.getBrushSize() * v.getBrushSize();
        HashMap frequency = Maps.newHashMap();
        for (int x = -brushSize; x <= brushSize; ++x) {
            for (int y = -brushSize; y <= brushSize; ++y) {
                for (int z = -brushSize; z <= brushSize; ++z) {
                    BlockState state;
                    target.set(x, y, z, current.get(x, y, z));
                    if ((double)(x * x + y * y + z * z) >= brushSizeSquared || !BlockHelper.isLiquidOrGas(state = current.get(x, y, z))) continue;
                    int total = 0;
                    int highest = 1;
                    BlockState highestState = state;
                    frequency.clear();
                    for (Vector3i offs : FACES_TO_CHECK) {
                        BlockState next = current.get(x + offs.getX(), y + offs.getY(), z + offs.getZ());
                        if (BlockHelper.isLiquidOrGas(next)) continue;
                        ++total;
                        Integer count = (Integer)frequency.get(next);
                        if (count == null) {
                            count = 1;
                        } else {
                            Integer n = count;
                            Integer n2 = count = Integer.valueOf(count + 1);
                        }
                        if (count > highest) {
                            highest = count;
                            highestState = next;
                        }
                        frequency.put(next, count);
                    }
                    if (total < fillFaces) continue;
                    target.set(x, y, z, highestState);
                }
            }
        }
    }

    private void erosionIteration(SnipeData v, int erodeFaces, BlockBuffer current, BlockBuffer target) {
        int brushSize = (int)v.getBrushSize() + 1;
        double brushSizeSquared = v.getBrushSize() * v.getBrushSize();
        HashMap frequency = Maps.newHashMap();
        for (int x = -brushSize; x <= brushSize; ++x) {
            for (int y = -brushSize; y <= brushSize; ++y) {
                for (int z = -brushSize; z <= brushSize; ++z) {
                    BlockState state;
                    target.set(x, y, z, current.get(x, y, z));
                    if ((double)(x * x + y * y + z * z) >= brushSizeSquared || BlockHelper.isLiquidOrGas(state = current.get(x, y, z))) continue;
                    int total = 0;
                    int highest = 1;
                    BlockType highestState = state.getType();
                    frequency.clear();
                    for (Vector3i offs : FACES_TO_CHECK) {
                        BlockState next = current.get(x + offs.getX(), y + offs.getY(), z + offs.getZ());
                        if (!BlockHelper.isLiquidOrGas(next)) continue;
                        ++total;
                        Integer count = (Integer)frequency.get(next.getType());
                        if (count == null) {
                            count = 1;
                        } else {
                            Integer n = count;
                            Integer n2 = count = Integer.valueOf(count + 1);
                        }
                        if (count > highest) {
                            highest = count;
                            highestState = next.getType();
                        }
                        frequency.put(next.getType(), count);
                    }
                    if (total < erodeFaces) continue;
                    target.set(x, y, z, highestState.getDefaultState());
                }
            }
        }
    }

    @Override
    protected void arrow(SnipeData v) {
        this.erosion(v, this.currentPreset.getErosionFaces(), this.currentPreset.getErosionRecursion(), this.currentPreset.getFillFaces(), this.currentPreset.getFillRecursion());
    }

    @Override
    protected void powder(SnipeData v) {
        ErosionParameters i = this.currentPreset.getInverted();
        this.erosion(v, i.getErosionFaces(), i.getErosionRecursion(), i.getFillFaces(), i.getFillRecursion());
    }

    @Override
    public void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(TextColors.AQUA, "Erosion minimum exposed faces set to " + this.currentPreset.getErosionFaces());
        vm.custom(TextColors.BLUE, "Fill minumum touching faces set to " + this.currentPreset.getFillFaces());
        vm.custom(TextColors.DARK_BLUE, "Erosion recursion amount set to " + this.currentPreset.getErosionRecursion());
        vm.custom(TextColors.DARK_GREEN, "Fill recursion amount set to " + this.currentPreset.getFillRecursion());
    }

    private void printOptions(SnipeData v) {
        Text.Builder builder = Text.builder();
        builder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "Available presets are: "})});
        for (int i = 0; i < Preset.values().length; ++i) {
            Preset preset = Preset.values()[i];
            if (i != Preset.values().length - 1) {
                builder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, preset.name().toLowerCase(), TextColors.AQUA, ", "})});
                continue;
            }
            builder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, preset.name().toLowerCase()})});
        }
        v.sendMessage(builder.toText());
    }

    @Override
    public void parameters(String[] par, SnipeData v) {
        ErosionParameters currentPresetBackup = this.currentPreset;
        if (par.length == 0) {
            this.printOptions(v);
            return;
        }
        Preset selection = Preset.tryValueOf(par[0]);
        if (selection == null) {
            this.printOptions(v);
            return;
        }
        this.currentPreset = selection.getParameters();
        if (!this.currentPreset.equals(currentPresetBackup)) {
            v.sendMessage(TextColors.AQUA, "Erosion minimum exposed faces set to ", TextColors.WHITE, this.currentPreset.getErosionFaces());
            v.sendMessage(TextColors.BLUE, "Fill minumum touching faces set to ", TextColors.WHITE, this.currentPreset.getFillFaces());
            v.sendMessage(TextColors.DARK_BLUE, "Erosion recursion amount set to ", TextColors.WHITE, this.currentPreset.getErosionRecursion());
            v.sendMessage(TextColors.DARK_GREEN, "Fill recursion amount set to ", TextColors.WHITE, this.currentPreset.getFillRecursion());
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.erode";
    }

    private static final class ErosionParameters {
        private final int erosionFaces;
        private final int erosionRecursion;
        private final int fillFaces;
        private final int fillRecursion;
        private ErosionParameters inverse = null;

        public ErosionParameters(int erosionFaces, int erosionRecursion, int fillFaces, int fillRecursion) {
            this.erosionFaces = erosionFaces;
            this.erosionRecursion = erosionRecursion;
            this.fillFaces = fillFaces;
            this.fillRecursion = fillRecursion;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.erosionFaces, this.erosionRecursion, this.fillFaces, this.fillRecursion});
        }

        public boolean equals(Object obj) {
            if (obj instanceof ErosionParameters) {
                ErosionParameters other = (ErosionParameters)obj;
                return Objects.equal((Object)this.erosionFaces, (Object)other.erosionFaces) && Objects.equal((Object)this.erosionRecursion, (Object)other.erosionRecursion) && Objects.equal((Object)this.fillFaces, (Object)other.fillFaces) && Objects.equal((Object)this.fillRecursion, (Object)other.fillRecursion);
            }
            return false;
        }

        public int getErosionFaces() {
            return this.erosionFaces;
        }

        public int getErosionRecursion() {
            return this.erosionRecursion;
        }

        public int getFillFaces() {
            return this.fillFaces;
        }

        public int getFillRecursion() {
            return this.fillRecursion;
        }

        public ErosionParameters getInverted() {
            if (this.inverse == null) {
                this.inverse = new ErosionParameters(this.fillFaces, this.fillRecursion, this.erosionFaces, this.erosionRecursion);
            }
            return this.inverse;
        }
    }

    private static enum Preset {
        MELT(new ErosionParameters(2, 1, 5, 1)),
        FILL(new ErosionParameters(5, 1, 2, 1)),
        SMOOTH(new ErosionParameters(3, 1, 3, 1)),
        LIFT(new ErosionParameters(6, 0, 1, 1)),
        LOWER(new ErosionParameters(1, 1, 6, 0)),
        FLOATCLEAN(new ErosionParameters(6, 1, 6, 1));

        private ErosionParameters preset;

        public static Preset tryValueOf(String name) {
            try {
                return Preset.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        private Preset(ErosionParameters preset) {
            this.preset = preset;
        }

        public ErosionParameters getParameters() {
            return this.preset;
        }
    }
}

