/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.terrain;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import java.util.Random;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SplatterBallBrush
extends PerformBrush {
    private static final double GROW_PERCENT_DEFAULT = 0.1;
    private static final double SEED_PERCENT_DEFAULT = 0.1;
    private static final int RECURSIONS_MIN = 1;
    private static final int RECURSIONS_DEFAULT = 3;
    private static final int RECURSIONS_MAX = 20;
    private double seedPercent = 0.1;
    private double growPercent = 0.1;
    private int splatterRecursions = 3;
    private Random generator = new Random();

    public SplatterBallBrush() {
        this.setName("Splatter Ball");
    }

    private void splatterBall(SnipeData v, Location<World> targetBlock) {
        int size = (int)Math.round(v.getBrushSize());
        boolean[][][] splat = new boolean[2 * size + 1][2 * size + 1][2 * size + 1];
        for (int x = 2 * size; x >= 0; --x) {
            for (int y = 2 * size; y >= 0; --y) {
                for (int z = 2 * size; z >= 0; --z) {
                    if (!(this.generator.nextDouble() <= this.seedPercent)) continue;
                    splat[x][y][z] = true;
                }
            }
        }
        boolean[][][] tempSplat = new boolean[2 * size + 1][2 * size + 1][2 * size + 1];
        for (int r = 0; r < this.splatterRecursions; ++r) {
            int z;
            int y;
            int x;
            double grow = this.growPercent - this.growPercent / (double)this.splatterRecursions * (double)r;
            for (x = 2 * size; x >= 0; --x) {
                for (y = 2 * size; y >= 0; --y) {
                    for (z = 2 * size; z >= 0; --z) {
                        tempSplat[x][y][z] = splat[x][y][z];
                        int growcheck = 0;
                        if (!splat[x][y][z]) {
                            if (x != 0 && splat[x - 1][y][z]) {
                                ++growcheck;
                            }
                            if (y != 0 && splat[x][y - 1][z]) {
                                ++growcheck;
                            }
                            if (z != 0 && splat[x][y][z - 1]) {
                                ++growcheck;
                            }
                            if (x != 2 * size && splat[x + 1][y][z]) {
                                ++growcheck;
                            }
                            if (y != 2 * size && splat[x][y + 1][z]) {
                                ++growcheck;
                            }
                            if (z != 2 * size && splat[x][y][z + 1]) {
                                ++growcheck;
                            }
                        }
                        if (growcheck < 0 || !(this.generator.nextDouble() <= grow)) continue;
                        tempSplat[x][y][z] = true;
                    }
                }
            }
            for (x = 2 * size; x >= 0; --x) {
                for (y = 2 * size; y >= 0; --y) {
                    for (z = 2 * size; z >= 0; --z) {
                        splat[x][y][z] = tempSplat[x][y][z];
                    }
                }
            }
        }
        for (int x = 2 * size - 2; x >= 1; --x) {
            for (int y = 2 * size - 2; y >= 1; --y) {
                for (int z = 2 * size - 2; z >= 1; --z) {
                    if (!splat[x - 1][y][z] || !splat[x + 1][y][z] || !splat[x][y - 1][z] || !splat[x][y + 1][z] || !splat[x][y][z - 1] || !splat[x][y][z + 1]) continue;
                    splat[x][y][z] = true;
                }
            }
        }
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * 4 * (v.getBrushSize() + 1.0) * (v.getBrushSize() + 1.0) * (v.getBrushSize() + 1.0) / 3.0)));
        double rSquared = v.getBrushSize() * v.getBrushSize();
        for (int x = 2 * size; x >= 0; --x) {
            double xSquared = (x - size) * (x - size);
            int x0 = x - size + targetBlock.getBlockX();
            for (int y = 2 * size; y >= 0; --y) {
                double ySquared = (y - size) * (y - size);
                int y0 = y - size + targetBlock.getBlockY();
                for (int z = 2 * size; z >= 0; --z) {
                    double zSquared = (z - size) * (z - size);
                    int z0 = z - size + targetBlock.getBlockZ();
                    if (!splat[x][y][z] || !(xSquared + ySquared + zSquared <= rSquared)) continue;
                    this.perform(v, x0, y0, z0);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.splatterBall(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.splatterBall(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName("Splatter Ball");
        vm.size();
        vm.custom(TextColors.BLUE, "Seed percent set to: " + this.seedPercent * 100.0 + "%");
        vm.custom(TextColors.BLUE, "Growth percent set to: " + this.growPercent * 100.0 + "%");
        vm.custom(TextColors.BLUE, "Recursions set to: " + this.splatterRecursions);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD, "Splatter Ball brush Parameters:");
                v.sendMessage(TextColors.AQUA, "/b sb s[float] -- set a seed percentage (0-1). Default is 0.1");
                v.sendMessage(TextColors.AQUA, "/b sb g[float] -- set a growth percentage (0-1). Default is 0.1");
                v.sendMessage(TextColors.AQUA, "/b sb r[int] -- set a recursion (1-10).  Default is 3");
                return;
            }
            if (parameter.startsWith("s")) {
                try {
                    double temp = Double.parseDouble(parameter.replace("s", ""));
                    if (temp >= 0.0 && temp <= 1.0) {
                        v.sendMessage(TextColors.AQUA, "Seed percent set to: " + temp * 100.0 + "%");
                        this.seedPercent = temp;
                        continue;
                    }
                    v.sendMessage(TextColors.RED, "Seed percent must be a decimal between 0 and 1!");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid seed percent.");
                }
                continue;
            }
            if (parameter.startsWith("g")) {
                try {
                    double temp = Double.parseDouble(parameter.replace("g", ""));
                    if (temp >= 0.0 && temp <= 1.0) {
                        v.sendMessage(TextColors.AQUA, "Growth percent set to: " + temp * 100.0 + "%");
                        this.growPercent = temp;
                        continue;
                    }
                    v.sendMessage(TextColors.RED, "Growth percent must be a decimal between 0 and 1!");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid growth percent.");
                }
                continue;
            }
            if (parameter.startsWith("r")) {
                try {
                    int temp = Integer.parseInt(parameter.replace("r", ""));
                    if (temp >= 1 && temp <= 20) {
                        v.sendMessage(TextColors.AQUA, "Recursions set to: " + temp);
                        this.splatterRecursions = temp;
                        continue;
                    }
                    v.sendMessage(TextColors.RED, "Recursions must be an integer 1-20");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid recursion count.");
                }
                continue;
            }
            v.sendMessage(TextColors.RED, "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.splatterball";
    }
}

