/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.terrain;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import java.util.Random;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SplatterOverlayBrush
extends PerformBrush {
    private static final double GROW_PERCENT_DEFAULT = 0.1;
    private static final double SEED_PERCENT_DEFAULT = 0.1;
    private static final int RECURSIONS_MIN = 1;
    private static final int RECURSIONS_DEFAULT = 3;
    private static final int RECURSIONS_MAX = 20;
    private double seedPercent = 0.1;
    private double growPercent = 0.1;
    private int splatterRecursions = 3;
    private Random generator = new Random();
    private int depth = 3;

    public SplatterOverlayBrush() {
        this.setName("Splatter Overlay");
    }

    private void splatterOverlay(SnipeData v, Location<World> targetBlock) {
        int x;
        int size = GenericMath.floor((double)v.getBrushSize()) + 1;
        double sizeSquared = v.getBrushSize() * v.getBrushSize();
        int tx = targetBlock.getBlockX();
        int ty = targetBlock.getBlockY();
        int tz = targetBlock.getBlockZ();
        byte[][][] splat = new byte[2 * size + 1][ty][2 * size + 1];
        int miny = WORLD_HEIGHT;
        for (int x2 = -size; x2 <= size; ++x2) {
            int x0 = tx + x2;
            block1: for (int z = -size; z <= size; ++z) {
                int z0 = tx + z;
                if ((double)(x2 * x2 + z * z) >= sizeSquared) continue;
                for (int y = ty; y >= 0; --y) {
                    if (this.world.getBlockType(x0, y, z0) == BlockTypes.AIR) continue;
                    if (y == ty) continue block1;
                    for (int y0 = y; y0 >= y - this.depth; --y0) {
                        if (this.world.getBlockType(x0, y, z0) == BlockTypes.AIR) continue block1;
                        splat[x2 + size][y0][z + size] = this.generator.nextDouble() < this.growPercent ? 2 : 1;
                        if (y0 >= miny) continue;
                        miny = y0;
                    }
                }
            }
        }
        int y_range = ty - miny + 1;
        byte[][][] tempSplat = new byte[2 * size + 1][y_range][2 * size + 1];
        for (int r = 0; r < this.splatterRecursions; ++r) {
            int y0;
            int y;
            int zi;
            int z;
            int xi;
            int x3;
            double grow = this.growPercent - this.growPercent / (double)this.splatterRecursions * (double)r;
            for (x3 = -size; x3 <= size; ++x3) {
                xi = x3 + size;
                for (z = -size; z <= size; ++z) {
                    zi = z + size;
                    for (y = 0; y <= y_range; ++y) {
                        y0 = miny + y;
                        tempSplat[xi][y][zi] = splat[xi][y0][zi];
                        int growcheck = 0;
                        if (splat[xi][y0][zi] != 1) continue;
                        if (xi != 0 && splat[xi - 1][y0][zi] == 2) {
                            ++growcheck;
                        }
                        if (y != 0 && splat[xi][y0 - 1][zi] == 2) {
                            ++growcheck;
                        }
                        if (zi != 0 && splat[xi][y0][zi - 1] == 2) {
                            ++growcheck;
                        }
                        if (xi != 2 * size && splat[xi + 1][y0][zi] == 2) {
                            ++growcheck;
                        }
                        if (y0 != ty && splat[xi][y0 + 1][zi] == 2) {
                            ++growcheck;
                        }
                        if (zi != 2 * size && splat[xi][y0][zi + 1] == 2) {
                            ++growcheck;
                        }
                        if (growcheck < 0 || !(this.generator.nextDouble() <= grow)) continue;
                        tempSplat[xi][y][zi] = 2;
                    }
                }
            }
            for (x3 = -size; x3 <= size; ++x3) {
                xi = x3 + size;
                for (z = -size; z <= size; ++z) {
                    zi = z + size;
                    for (y = 0; y <= y_range; ++y) {
                        y0 = miny + y;
                        splat[xi][y0][zi] = tempSplat[xi][y][zi];
                    }
                }
            }
        }
        for (x = -size; x <= size; ++x) {
            int xi = x + size;
            for (int z = -size; z <= size; ++z) {
                int zi = z + size;
                for (int y = 0; y <= y_range; ++y) {
                    int y0 = miny + y;
                    if (splat[xi - 1][y0][zi] != 2 || splat[xi + 1][y0][zi] != 2 || splat[xi][y0 - 1][zi] != 2 || splat[xi][y0 + 1][zi] != 2 || splat[xi][y0][zi - 1] != 2 || splat[xi][y0][zi + 1] != 2) continue;
                    splat[xi][y0][zi] = 2;
                }
            }
        }
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * 4 * (v.getBrushSize() + 1.0) * (v.getBrushSize() + 1.0) * (v.getBrushSize() + 1.0) / 3.0)));
        for (x = -size; x <= size; ++x) {
            int xi = x + size;
            int x0 = x + tx;
            for (int z = -size; z <= size; ++z) {
                int zi = z + size;
                int z0 = z + tz;
                for (int y = 0; y <= y_range; ++y) {
                    int y0 = miny + y;
                    if (splat[xi][y0][zi] != 2) continue;
                    this.perform(v, x0, y0, z0);
                }
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.splatterOverlay(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.splatterOverlay(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(TextColors.BLUE, "Seed percent set to: " + this.seedPercent / 100.0 + "%");
        vm.custom(TextColors.BLUE, "Growth percent set to: " + this.growPercent / 100.0 + "%");
        vm.custom(TextColors.BLUE, "Recursions set to: " + this.splatterRecursions);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD, "Splatter Overlay brush parameters:");
                v.sendMessage(TextColors.AQUA, "d[int] (ex:  d3) How many blocks deep you want to replace from the surface.");
                v.sendMessage(TextColors.AQUA, "/b sover s[float] -- set a seed percentage (0 - 1). Default is 0.1");
                v.sendMessage(TextColors.AQUA, "/b sover g[float] -- set a growth percentage (0 - 1).  Default is 0.1");
                v.sendMessage(TextColors.AQUA, "/b sover r[int] -- set a recursion (1 - 10).  Default is 3");
                return;
            }
            if (parameter.startsWith("d")) {
                try {
                    this.depth = Integer.parseInt(parameter.replace("d", ""));
                    if (this.depth < 1) {
                        this.depth = 1;
                    }
                    v.sendMessage(TextColors.AQUA, "Depth set to " + this.depth);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid depth provided.");
                }
                continue;
            }
            if (parameter.startsWith("s")) {
                try {
                    double temp = Double.parseDouble(parameter.replace("s", ""));
                    if (temp >= 0.0 && temp <= 1.0) {
                        v.sendMessage(TextColors.AQUA, "Seed percent set to: " + temp * 100.0 + "%");
                        this.seedPercent = temp;
                        continue;
                    }
                    v.sendMessage(TextColors.RED, "Seed percent must be a decimal between 0 and 1!");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid seed percent.");
                }
                continue;
            }
            if (parameter.startsWith("g")) {
                try {
                    double temp = Double.parseDouble(parameter.replace("g", ""));
                    if (temp >= 0.0 && temp <= 1.0) {
                        v.sendMessage(TextColors.AQUA, "Growth percent set to: " + temp * 100.0 + "%");
                        this.growPercent = temp;
                        continue;
                    }
                    v.sendMessage(TextColors.RED, "Growth percent must be a decimal between 0 and 1!");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid growth percent.");
                }
                continue;
            }
            if (parameter.startsWith("r")) {
                try {
                    int temp = Integer.parseInt(parameter.replace("r", ""));
                    if (temp >= 1 && temp <= 20) {
                        v.sendMessage(TextColors.AQUA, "Recursions set to: " + temp);
                        this.splatterRecursions = temp;
                        continue;
                    }
                    v.sendMessage(TextColors.RED, "Recursions must be an integer 1-20");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid recursion count.");
                }
                continue;
            }
            v.sendMessage(TextColors.RED, "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.splatteroverlay";
    }
}

