/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush.terrain;

import com.flowpowered.math.GenericMath;
import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import java.util.Random;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SplatterVoxelDiscBrush
extends PerformBrush {
    private static final double GROW_PERCENT_DEFAULT = 0.1;
    private static final double SEED_PERCENT_DEFAULT = 0.1;
    private static final int RECURSIONS_MIN = 1;
    private static final int RECURSIONS_DEFAULT = 3;
    private static final int RECURSIONS_MAX = 20;
    private double seedPercent = 0.1;
    private double growPercent = 0.1;
    private int splatterRecursions = 3;
    private Random generator = new Random();

    public SplatterVoxelDiscBrush() {
        this.setName("Splatter VoxelDisc");
    }

    private void splatterVoxelDisc(SnipeData v, Location<World> targetBlock) {
        int x;
        int size = (int)Math.round(v.getBrushSize());
        boolean[][] splat = new boolean[2 * size + 1][2 * size + 1];
        for (int x2 = 2 * size; x2 >= 0; --x2) {
            for (int z = 2 * size; z >= 0; --z) {
                if (!(this.generator.nextDouble() <= this.seedPercent)) continue;
                splat[x2][z] = true;
            }
        }
        boolean[][] tempSplat = new boolean[2 * size + 1][2 * size + 1];
        for (int r = 0; r < this.splatterRecursions; ++r) {
            int z;
            int x3;
            double grow = this.growPercent - this.growPercent / (double)this.splatterRecursions * (double)r;
            for (x3 = 2 * size; x3 >= 0; --x3) {
                for (z = 2 * size; z >= 0; --z) {
                    tempSplat[x3][z] = splat[x3][z];
                    int growcheck = 0;
                    if (!splat[x3][z]) {
                        if (x3 != 0 && splat[x3 - 1][z]) {
                            ++growcheck;
                        }
                        if (z != 0 && splat[x3][z - 1]) {
                            ++growcheck;
                        }
                        if (x3 != 2 * size && splat[x3 + 1][z]) {
                            ++growcheck;
                        }
                        if (z != 2 * size && splat[x3][z + 1]) {
                            ++growcheck;
                        }
                    }
                    if (growcheck < 0 || !(this.generator.nextDouble() <= grow)) continue;
                    tempSplat[x3][z] = true;
                }
            }
            for (x3 = 2 * size; x3 >= 0; --x3) {
                for (z = 2 * size; z >= 0; --z) {
                    splat[x3][z] = tempSplat[x3][z];
                }
            }
        }
        for (x = 2 * size - 1; x >= 1; --x) {
            for (int z = size - 1; z >= 1; --z) {
                if (!splat[x - 1][z] || !splat[x + 1][z] || !splat[x][z - 1] || !splat[x][z + 1]) continue;
                splat[x][z] = true;
            }
        }
        this.undo = new Undo(GenericMath.floor((double)(Math.PI * 2 * (v.getBrushSize() + 1.0) * (v.getBrushSize() + 1.0))));
        for (x = 2 * size; x >= 0; --x) {
            int x0 = x - size + targetBlock.getBlockX();
            for (int z = 2 * size; z >= 0; --z) {
                int z0 = z - size + targetBlock.getBlockZ();
                if (!splat[x][z]) continue;
                this.perform(v, x0, targetBlock.getBlockY(), z0);
            }
        }
        v.owner().storeUndo(this.undo);
        this.undo = null;
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.splatterVoxelDisc(v, (Location<World>)this.targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.splatterVoxelDisc(v, (Location<World>)this.lastBlock);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName("Splatter VoxelDisc");
        vm.size();
        vm.custom(TextColors.BLUE, "Seed percent set to: " + this.seedPercent * 100.0 + "%");
        vm.custom(TextColors.BLUE, "Growth percent set to: " + this.growPercent * 100.0 + "%");
        vm.custom(TextColors.BLUE, "Recursions set to: " + this.splatterRecursions);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(TextColors.GOLD, "Splatter VoxelDisc brush Parameters:");
                v.sendMessage(TextColors.AQUA, "/b svd s[float] -- set a seed percentage (0 - 1). Default is 0.1");
                v.sendMessage(TextColors.AQUA, "/b svd g[float] -- set a growth percentage (0 - 1). Default is 0.1");
                v.sendMessage(TextColors.AQUA, "/b svd r[int] -- set a recursion (1-10).  Default is 3");
                return;
            }
            if (parameter.startsWith("s")) {
                try {
                    double temp = Double.parseDouble(parameter.replace("s", ""));
                    if (temp >= 0.0 && temp <= 1.0) {
                        v.sendMessage(TextColors.AQUA, "Seed percent set to: " + temp * 100.0 + "%");
                        this.seedPercent = temp;
                        continue;
                    }
                    v.sendMessage(TextColors.RED, "Seed percent must be a decimal between 0 and 1!");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid seed percent.");
                }
                continue;
            }
            if (parameter.startsWith("g")) {
                try {
                    double temp = Double.parseDouble(parameter.replace("g", ""));
                    if (temp >= 0.0 && temp <= 1.0) {
                        v.sendMessage(TextColors.AQUA, "Growth percent set to: " + temp * 100.0 + "%");
                        this.growPercent = temp;
                        continue;
                    }
                    v.sendMessage(TextColors.RED, "Growth percent must be a decimal between 0 and 1!");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid growth percent.");
                }
                continue;
            }
            if (parameter.startsWith("r")) {
                try {
                    int temp = Integer.parseInt(parameter.replace("r", ""));
                    if (temp >= 1 && temp <= 20) {
                        v.sendMessage(TextColors.AQUA, "Recursions set to: " + temp);
                        this.splatterRecursions = temp;
                        continue;
                    }
                    v.sendMessage(TextColors.RED, "Recursions must be an integer 1-20");
                }
                catch (NumberFormatException e) {
                    v.sendMessage(TextColors.RED, "Invalid recursion count.");
                }
                continue;
            }
            v.sendMessage(TextColors.RED, "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.splattervoxeldisc";
    }
}

