/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.command;

import com.thevoxelbox.voxelsniper.Brushes;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.SniperManager;
import com.thevoxelbox.voxelsniper.VoxelSniperConfiguration;
import com.thevoxelbox.voxelsniper.brush.IBrush;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import com.thevoxelbox.voxelsniper.event.sniper.ChangeBrushSizeEvent;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class VoxelBrushCommand
implements CommandExecutor {
    public static void setup(Object plugin) {
        Sponge.getCommandManager().register(plugin, (CommandCallable)CommandSpec.builder().arguments(new CommandElement[]{GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"brush"))), GenericArguments.optional((CommandElement)GenericArguments.remainingJoinedStrings((Text)Text.of((String)"brush_args")))}).executor((CommandExecutor)new VoxelBrushCommand()).permission("voxelsniper.sniper").description((Text)Text.of((String)"VoxelSniper brush settings")).build(), new String[]{"b", "brush"});
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            src.sendMessage((Text)Text.of((String)"Player only."));
            return CommandResult.success();
        }
        Player player = (Player)src;
        Sniper sniper = SniperManager.get().getSniperForPlayer(player);
        String currentToolId = sniper.getCurrentToolId();
        SnipeData snipeData = sniper.getSnipeData(currentToolId);
        Optional brush_selection = args.getOne("brush");
        if (!brush_selection.isPresent()) {
            sniper.displayInfo();
            return CommandResult.success();
        }
        try {
            double newBrushSize = Double.parseDouble((String)brush_selection.get());
            if (!player.hasPermission("voxelsniper.ignorelimitations") && newBrushSize > VoxelSniperConfiguration.LITESNIPER_MAX_BRUSH_SIZE) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Size is restricted to " + VoxelSniperConfiguration.LITESNIPER_MAX_BRUSH_SIZE + " for you."}));
                newBrushSize = VoxelSniperConfiguration.LITESNIPER_MAX_BRUSH_SIZE;
            }
            ChangeBrushSizeEvent event = new ChangeBrushSizeEvent(Sponge.getCauseStackManager().getCurrentCause(), snipeData, newBrushSize);
            Sponge.getEventManager().post((Event)event);
            snipeData.setBrushSize(newBrushSize);
            snipeData.getVoxelMessage().size();
            return CommandResult.success();
        }
        catch (NumberFormatException newBrushSize) {
            Optional brush_args = args.getOne("brush_args");
            Class<? extends IBrush> brush = Brushes.get().getBrushForHandle((String)brush_selection.get());
            if (brush != null) {
                sniper.setBrush(currentToolId, brush);
                if (brush_args.isPresent()) {
                    String[] bargs = ((String)brush_args.get()).split(" ");
                    IBrush currentBrush = sniper.getBrush(currentToolId);
                    if (currentBrush instanceof PerformBrush) {
                        ((PerformBrush)currentBrush).parse(bargs, snipeData);
                    } else {
                        currentBrush.parameters(bargs, snipeData);
                    }
                }
                sniper.displayInfo();
            } else {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Couldn't find Brush for brush handle \"" + (String)brush_selection.get() + "\""}));
            }
            return CommandResult.success();
        }
    }
}

