/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.command;

import com.thevoxelbox.voxelsniper.SnipeAction;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.SniperManager;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class VoxelBrushToolCommand
implements CommandExecutor {
    public static void setup(Object plugin) {
        Sponge.getCommandManager().register(plugin, (CommandCallable)CommandSpec.builder().arguments(new CommandElement[]{GenericArguments.playerOrSource((Text)Text.of((String)"sniper")), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"args"))}).executor((CommandExecutor)new VoxelBrushToolCommand()).permission("voxelsniper.sniper").description((Text)Text.of((String)"VoxelSniper brush tool settings")).build(), new String[]{"btool"});
    }

    public CommandResult execute(CommandSource src, CommandContext gargs) throws CommandException {
        Player player = (Player)gargs.getOne("sniper").get();
        Sniper sniper = SniperManager.get().getSniperForPlayer(player);
        Optional oargs = gargs.getOne("args");
        if (oargs.isPresent() && !((String)oargs.get()).isEmpty()) {
            String[] args = ((String)oargs.get()).split(" ");
            if (args[0].equalsIgnoreCase("assign")) {
                SnipeAction action;
                if (args.length == 1) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Usage: /btool assign <arrow|powder> <toolid>"}));
                    return CommandResult.success();
                }
                if (args[1].equalsIgnoreCase("arrow")) {
                    action = SnipeAction.ARROW;
                } else if (args[1].equalsIgnoreCase("powder")) {
                    action = SnipeAction.GUNPOWDER;
                } else {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Usage: /btool assign <arrow|powder> <toolid>"}));
                    return CommandResult.success();
                }
                if (args.length == 3) {
                    Optional itemInHand = player.getItemInHand(HandTypes.MAIN_HAND);
                    if (!itemInHand.isPresent()) {
                        player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must have an item in your main hand to assign a brush tool."}));
                        return CommandResult.success();
                    }
                    if (sniper.setTool(args[2], action, ((ItemStack)itemInHand.get()).getType())) {
                        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, ((ItemStack)itemInHand.get()).getType().getId() + " has been assigned to '" + args[2] + "' as action " + action.name() + "."}));
                    } else {
                        player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Couldn't assign tool."}));
                    }
                    return CommandResult.success();
                }
            } else if (args[0].equalsIgnoreCase("remove")) {
                ItemType itemInHand;
                if (args.length == 2) {
                    sniper.removeTool(args[1]);
                    return CommandResult.success();
                }
                ItemType itemType = itemInHand = player.getItemInHand(HandTypes.MAIN_HAND).isPresent() ? ((ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get()).getType() : null;
                if (itemInHand == null) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Can't unassign empty hands."}));
                    return CommandResult.success();
                }
                if (sniper.getCurrentToolId() == null) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Can't unassign default tool."}));
                    return CommandResult.success();
                }
                sniper.removeTool(sniper.getCurrentToolId(), itemInHand);
                return CommandResult.success();
            }
        }
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Usage: /btool assign <arrow|powder> <toolid>"}));
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Usage: /btool remove [toolid]"}));
        return CommandResult.success();
    }
}

