/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.command;

import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.SniperManager;
import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.world.Location;

public class VoxelListCommand
implements CommandExecutor {
    public static void setup(Object plugin) {
        Sponge.getCommandManager().register(plugin, (CommandCallable)CommandSpec.builder().arguments(new CommandElement[]{GenericArguments.playerOrSource((Text)Text.of((String)"sniper")), GenericArguments.optional((CommandElement)GenericArguments.remainingJoinedStrings((Text)Text.of((String)"args")))}).executor((CommandExecutor)new VoxelListCommand()).permission("voxelsniper.sniper").description((Text)Text.of((String)"VoxelSniper material list selection")).build(), new String[]{"vl"});
    }

    public CommandResult execute(CommandSource src, CommandContext gargs) throws CommandException {
        Player player = (Player)gargs.getOne("sniper").get();
        Sniper sniper = SniperManager.get().getSniperForPlayer(player);
        Optional oargs = gargs.getOne("args");
        SnipeData snipeData = sniper.getSnipeData(sniper.getCurrentToolId());
        if (!oargs.isPresent()) {
            Location targetBlock = null;
            BlockRay.BlockRayBuilder rayBuilder = BlockRay.from((Entity)player).stopFilter(BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1));
            BlockRay ray = rayBuilder.build();
            while (ray.hasNext()) {
                targetBlock = ray.next().getLocation();
            }
            snipeData.getVoxelList().add(targetBlock.getBlock());
            snipeData.getVoxelMessage().voxelList();
            return CommandResult.success();
        }
        String[] args = ((String)oargs.get()).split(" ");
        if (args[0].equalsIgnoreCase("clear")) {
            snipeData.getVoxelList().clear();
            snipeData.getVoxelMessage().voxelList();
            return CommandResult.success();
        }
        for (String arg : args) {
            Optional type;
            boolean remove = arg.startsWith("-");
            if (remove) {
                arg = arg.substring(1);
            }
            if ((type = Sponge.getRegistry().getType(BlockType.class, arg)).isPresent()) {
                if (remove) {
                    snipeData.getVoxelList().remove((BlockType)type.get());
                    continue;
                }
                snipeData.getVoxelList().add((BlockType)type.get());
                continue;
            }
            Optional state = Sponge.getRegistry().getType(BlockState.class, arg);
            if (state.isPresent()) {
                if (remove) {
                    snipeData.getVoxelList().remove((BlockState)state.get());
                    continue;
                }
                snipeData.getVoxelList().add((BlockState)state.get());
                continue;
            }
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Material not found."}));
        }
        snipeData.getVoxelMessage().voxelList();
        return CommandResult.success();
    }
}

