/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.command;

import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.SniperManager;
import com.thevoxelbox.voxelsniper.brush.IBrush;
import com.thevoxelbox.voxelsniper.brush.PerformBrush;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class VoxelPerformerCommand
implements CommandExecutor {
    public static void setup(Object plugin) {
        Sponge.getCommandManager().register(plugin, (CommandCallable)CommandSpec.builder().arguments(new CommandElement[]{GenericArguments.playerOrSource((Text)Text.of((String)"sniper")), GenericArguments.string((Text)Text.of((String)"performer"))}).executor((CommandExecutor)new VoxelPerformerCommand()).permission("voxelsniper.sniper").description((Text)Text.of((String)"VoxelSniper performer selection")).build(), new String[]{"p"});
    }

    public CommandResult execute(CommandSource src, CommandContext gargs) throws CommandException {
        Player player = (Player)gargs.getOne("sniper").get();
        Sniper sniper = SniperManager.get().getSniperForPlayer(player);
        SnipeData snipeData = sniper.getSnipeData(sniper.getCurrentToolId());
        String performer = (String)gargs.getOne("performer").get();
        IBrush brush = sniper.getBrush(sniper.getCurrentToolId());
        if (brush instanceof PerformBrush) {
            ((PerformBrush)brush).parse(new String[]{performer}, snipeData);
        } else {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "This brush is not a performer brush."}));
        }
        return CommandResult.success();
    }
}

