/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.command;

import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.SniperManager;
import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.world.Location;

public class VoxelReplaceCommand
implements CommandExecutor {
    public static void setup(Object plugin) {
        Sponge.getCommandManager().register(plugin, (CommandCallable)CommandSpec.builder().arguments(new CommandElement[]{GenericArguments.playerOrSource((Text)Text.of((String)"sniper")), GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"material")))}).executor((CommandExecutor)new VoxelReplaceCommand()).permission("voxelsniper.sniper").description((Text)Text.of((String)"VoxelSniper replace material selection")).build(), new String[]{"vr"});
    }

    public CommandResult execute(CommandSource src, CommandContext gargs) throws CommandException {
        Optional type;
        Player player = (Player)gargs.getOne("sniper").get();
        Sniper sniper = SniperManager.get().getSniperForPlayer(player);
        SnipeData snipeData = sniper.getSnipeData(sniper.getCurrentToolId());
        Optional material = gargs.getOne("material");
        if (!material.isPresent()) {
            Location targetBlock = null;
            BlockRay.BlockRayBuilder rayBuilder = BlockRay.from((Entity)player).stopFilter(BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1));
            BlockRay ray = rayBuilder.build();
            while (ray.hasNext()) {
                targetBlock = ray.next().getLocation();
            }
            snipeData.setReplaceId(targetBlock.getBlock());
            snipeData.getVoxelMessage().replace();
            return CommandResult.success();
        }
        String materialName = (String)material.get();
        if (!materialName.contains(":")) {
            materialName = "minecraft:" + materialName;
        }
        if ((type = Sponge.getRegistry().getType(BlockType.class, materialName)).isPresent()) {
            snipeData.setReplaceId(((BlockType)type.get()).getDefaultState());
            snipeData.getVoxelMessage().replace();
        } else {
            Optional state = Sponge.getRegistry().getType(BlockState.class, materialName);
            if (state.isPresent()) {
                snipeData.setReplaceId((BlockState)state.get());
                snipeData.getVoxelMessage().replace();
            } else {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Material not found."}));
            }
        }
        return CommandResult.success();
    }
}

