/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.command;

import com.thevoxelbox.voxelsniper.Brushes;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.SniperManager;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class VoxelSniperCommand
implements CommandExecutor {
    public static void setup(Object plugin) {
        Sponge.getCommandManager().register(plugin, (CommandCallable)CommandSpec.builder().arguments(new CommandElement[]{GenericArguments.playerOrSource((Text)Text.of((String)"sniper")), GenericArguments.optional((CommandElement)GenericArguments.remainingJoinedStrings((Text)Text.of((String)"args")))}).executor((CommandExecutor)new VoxelSniperCommand()).permission("voxelsniper.sniper").description((Text)Text.of((String)"VoxelSniper material list selection")).build(), new String[]{"vs"});
    }

    public CommandResult execute(CommandSource src, CommandContext gargs) throws CommandException {
        Player player = (Player)gargs.getOne("sniper").get();
        Sniper sniper = SniperManager.get().getSniperForPlayer(player);
        Optional oargs = gargs.getOne("args");
        if (oargs.isPresent()) {
            String[] args = ((String)oargs.get()).split(" ");
            if (args[0].equalsIgnoreCase("brushes")) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.AQUA, "All available brushes:"}));
                player.sendMessage((Text)Text.of((String)Brushes.get().getAllBrushes()));
                return CommandResult.success();
            }
            if (args[0].equalsIgnoreCase("version")) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.AQUA, "VoxelSniper version 8.5.0"}));
                return CommandResult.success();
            }
            if (args[0].equalsIgnoreCase("range")) {
                SnipeData snipeData = sniper.getSnipeData(sniper.getCurrentToolId());
                if (args.length == 2) {
                    try {
                        int range = Integer.parseInt(args[1]);
                        if (range < 0) {
                            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Negative range values are not allowed."}));
                        }
                        snipeData.setRange(range);
                        snipeData.setRanged(true);
                        snipeData.getVoxelMessage().toggleRange();
                    }
                    catch (NumberFormatException exception) {
                        player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Failed to parse number for range '" + args[1] + "'"}));
                    }
                    return CommandResult.success();
                }
                snipeData.setRanged(!snipeData.isRanged());
                snipeData.getVoxelMessage().toggleRange();
                return CommandResult.success();
            }
            if (args[0].equalsIgnoreCase("enable") && player.hasPermission("voxelsniper.command.vs.enable")) {
                sniper.setEnabled(true);
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "VoxelSniper is " + (sniper.isEnabled() ? "enabled" : "disabled")}));
                return CommandResult.success();
            }
            if (args[0].equalsIgnoreCase("disable") && player.hasPermission("voxelsniper.command.vs.enable")) {
                sniper.setEnabled(false);
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "VoxelSniper is " + (sniper.isEnabled() ? "enabled" : "disabled")}));
                return CommandResult.success();
            }
            if (args[0].equalsIgnoreCase("toggle") && player.hasPermission("voxelsniper.command.vs.enable")) {
                sniper.setEnabled(!sniper.isEnabled());
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "VoxelSniper is " + (sniper.isEnabled() ? "enabled" : "disabled")}));
                return CommandResult.success();
            }
        }
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "VoxelSniper - Current Brush Settings:"}));
        sniper.displayInfo();
        return CommandResult.success();
    }
}

