/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.util;

import com.flowpowered.math.vector.Vector3i;
import java.util.Arrays;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.BlockPaletteTypes;

public class BlockBuffer {
    private BlockPalette palette = BlockPaletteTypes.LOCAL.create();
    private final Vector3i min;
    private final Vector3i max;
    private final Vector3i size;
    private char[] buffer;
    private int count;

    public BlockBuffer(Vector3i min, Vector3i max) {
        this.min = min;
        this.max = max;
        this.size = this.max.sub(this.min).add(1, 1, 1);
        this.buffer = new char[this.size.getX() * this.size.getY() * this.size.getZ()];
        Arrays.fill(this.buffer, '\uffff');
    }

    private int index(int x, int y, int z) {
        return (x -= this.min.getX()) + (y -= this.min.getY()) * this.size.getX() + (z -= this.min.getZ()) * this.size.getX() * this.size.getY();
    }

    public Vector3i getMin() {
        return this.min;
    }

    public Vector3i getMax() {
        return this.max;
    }

    public Vector3i getSize() {
        return this.size;
    }

    public boolean contains(int x, int y, int z) {
        if (x < this.min.getX() || x > this.max.getX() || y < this.min.getX() || y > this.max.getX() || z < this.min.getX() || z > this.max.getX()) {
            return false;
        }
        return this.buffer[this.index(x, y, z)] != '\uffff';
    }

    public BlockState get(int x, int y, int z) {
        if (x < this.min.getX() || x > this.max.getX() || y < this.min.getY() || y > this.max.getY() || z < this.min.getZ() || z > this.max.getZ()) {
            throw new IllegalArgumentException("Expected block buffer position in range " + this.min + " to " + this.max + " but was (" + x + ", " + y + ", " + z + ")");
        }
        char id = this.buffer[this.index(x, y, z)];
        if (id == '\uffff') {
            return null;
        }
        return (BlockState)this.palette.get((int)id).get();
    }

    public void set(int x, int y, int z, BlockState state) {
        if (x < this.min.getX() || x > this.max.getX() || y < this.min.getY() || y > this.max.getY() || z < this.min.getZ() || z > this.max.getZ()) {
            throw new IllegalArgumentException("Expected block buffer position in range " + this.min + " to " + this.max + " but was (" + x + ", " + y + ", " + z + ")");
        }
        if (state == null) {
            if (this.buffer[this.index(x, y, z)] != '\uffff') {
                --this.count;
                this.buffer[this.index((int)x, (int)y, (int)z)] = 65535;
            }
            return;
        }
        if (this.buffer[this.index(x, y, z)] == '\uffff') {
            ++this.count;
        }
        int id = this.palette.getOrAssign(state);
        this.buffer[this.index((int)x, (int)y, (int)z)] = (char)id;
    }

    public int getBlockCount() {
        return this.count;
    }
}

