/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.util;

import com.thevoxelbox.voxelsniper.util.SchematicHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormats;

public class StencilUpdater {
    public static void update(File dir) {
        File updated = new File(dir.getParentFile(), "stencils-updated");
        if (updated.exists()) {
            System.err.println("Directory for updated stencils already exists. (" + updated.getAbsolutePath() + ")");
            System.err.println("Either remove this directory or rename the stencils directory to disable this warning.");
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                StencilUpdater.update(f);
                continue;
            }
            if (!f.getName().endsWith(".vstencil")) continue;
            StencilUpdater.updateStencil(f);
        }
        dir.renameTo(updated);
    }

    public static void updateStencil(File stencil) {
        String name = stencil.getName().replace(".vstencil", "");
        File schematicFile = SchematicHelper.getSchematicsDir().resolve(name + ".schem").toFile();
        if (schematicFile.exists()) {
            System.out.println("Schematic with name " + name + " already exists, skipping translating stencil with same name");
            return;
        }
        System.out.print("Translating " + stencil.getAbsolutePath() + " to schematic " + schematicFile.getAbsolutePath());
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(stencil)));){
            int w = in.readShort();
            int l = in.readShort();
            int h = in.readShort();
            short xRef = in.readShort();
            short zRef = in.readShort();
            short yRef = in.readShort();
            int runs = in.readInt();
            int[] blocks = new int[w * h * l];
            int cx = 0;
            int cy = 0;
            int cz = 0;
            for (int i = 0; i < runs; ++i) {
                int blockdata;
                boolean multi = in.readBoolean();
                if (multi) {
                    int count = in.readByte() + 128;
                    int blockid = in.readByte() + 128;
                    int data = in.readByte() + 128;
                    int blockdata2 = blockid << 4 | data & 0xF;
                    for (int c = 0; c < count; ++c) {
                        blocks[cx + cy * w + cz * w * h] = blockdata2;
                        if (++cx != w) continue;
                        cx = 0;
                        if (++cz != l) continue;
                        cz = 0;
                        ++cy;
                    }
                    continue;
                }
                int blockid = in.readByte() + 128;
                int data = in.readByte() + 128;
                blocks[cx + cy * w + cz * w * h] = blockdata = blockid << 4 | data & 0xF;
                if (++cx != w) continue;
                cx = 0;
                if (++cz != l) continue;
                cz = 0;
                ++cy;
            }
            DataContainer schematic = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
            schematic.set(DataQuery.of((String[])new String[]{"Width"}), (Object)w);
            schematic.set(DataQuery.of((String[])new String[]{"Height"}), (Object)h);
            schematic.set(DataQuery.of((String[])new String[]{"Length"}), (Object)l);
            schematic.set(DataQuery.of((String[])new String[]{"Version"}), (Object)1);
            DataView metadata = schematic.createView(DataQuery.of((String[])new String[]{"Metadata"}));
            metadata.set(DataQuery.of((String[])new String[]{"Name"}), (Object)name);
            int[] offset = new int[]{xRef, yRef, zRef};
            schematic.set(DataQuery.of((String[])new String[]{"Offset"}), (Object)offset);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(w * h * l);
            for (int y = 0; y < h; ++y) {
                for (int z = 0; z < l; ++z) {
                    for (int x = 0; x < w; ++x) {
                        int id = blocks[x + y * w + z * w * h];
                        while ((id & 0xFFFFFF80) != 0) {
                            buffer.write(id & 0x7F | 0x80);
                            id >>>= 7;
                        }
                        buffer.write(id);
                    }
                }
            }
            schematic.set(DataQuery.of((String[])new String[]{"BlockData"}), (Object)buffer.toByteArray());
            try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(schematicFile));){
                DataFormats.NBT.writeTo((OutputStream)out, (DataView)schematic);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

