/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.tile.AEBaseInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.InvOperation;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.items.IItemHandler;

public class TileSkyChest
extends AEBaseInvTile
implements ITickable {
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 36);
    private int numPlayersUsing;
    private long lastEvent;
    private float lidAngle;
    private float prevLidAngle;

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.getPlayerOpen() > 0);
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        int wasOpen = this.getPlayerOpen();
        this.setPlayerOpen(data.readBoolean() ? 1 : 0);
        if (wasOpen != this.getPlayerOpen()) {
            this.setLastEvent(System.currentTimeMillis());
        }
        return c;
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    public void openInventory(EntityPlayer player) {
        if (!player.func_175149_v()) {
            this.setPlayerOpen(this.getPlayerOpen() + 1);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), true);
            if (this.getPlayerOpen() == 1) {
                this.func_145831_w().func_184148_a(player, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
                this.markForUpdate();
            }
        }
    }

    public void closeInventory(EntityPlayer player) {
        if (!player.func_175149_v()) {
            this.setPlayerOpen(this.getPlayerOpen() - 1);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), true);
            if (this.getPlayerOpen() < 0) {
                this.setPlayerOpen(0);
            }
            if (this.getPlayerOpen() == 0) {
                this.func_145831_w().func_184148_a(player, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
                this.markForUpdate();
            }
        }
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        this.prevLidAngle = this.lidAngle;
        float f1 = 0.1f;
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float f3 = 0.5f;
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    public float getLidAngle() {
        return this.lidAngle;
    }

    public void setLidAngle(float lidAngle) {
        this.lidAngle = lidAngle;
    }

    public float getPrevLidAngle() {
        return this.prevLidAngle;
    }

    public void setPrevLidAngle(float prevLidAngle) {
        this.prevLidAngle = prevLidAngle;
    }

    public int getPlayerOpen() {
        return this.numPlayersUsing;
    }

    private void setPlayerOpen(int playerOpen) {
        this.numPlayersUsing = playerOpen;
    }

    public long getLastEvent() {
        return this.lastEvent;
    }

    private void setLastEvent(long lastEvent) {
        this.lastEvent = lastEvent;
    }
}

