/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.CachedBuilderModel;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.IconUtil;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.MaterialModelData;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import eutros.framedcompactdrawers.block.BlockControllerCustom;
import eutros.framedcompactdrawers.model.ControllerRenderer;
import eutros.framedcompactdrawers.registry.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CustomControllerModel
extends ChamModel {
    private static final ItemHandler itemHandler = new ItemHandler();
    private TextureAtlasSprite iconParticle;

    private CustomControllerModel(IBlockState state, boolean mergeLayers) {
        this(state, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, mergeLayers);
    }

    private CustomControllerModel(IBlockState state, @Nonnull ItemStack effMatFront, @Nonnull ItemStack effMatSide, @Nonnull ItemStack effMatTrim, @Nonnull ItemStack matFront, @Nonnull ItemStack matSide, @Nonnull ItemStack matTrim, boolean mergeLayers) {
        super(state, mergeLayers, new Object[]{effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim});
    }

    public static IBakedModel fromBlock(IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            return new CustomControllerModel(state, false);
        }
        IExtendedBlockState xState = (IExtendedBlockState)state;
        MaterialModelData matModel = (MaterialModelData)xState.getValue(BlockDrawersCustom.MAT_MODEL);
        if (matModel == null) {
            return new CustomControllerModel(state, false);
        }
        ItemStack effMatFront = matModel.getEffectiveMaterialFront();
        ItemStack effMatSide = matModel.getEffectiveMaterialSide();
        ItemStack effMatTrim = matModel.getEffectiveMaterialTrim();
        ItemStack matFront = matModel.getMaterialFront();
        ItemStack matSide = matModel.getMaterialSide();
        ItemStack matTrim = matModel.getMaterialTrim();
        return new CustomControllerModel(state, effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim, false);
    }

    public static IBakedModel fromItem(@Nonnull ItemStack stack) {
        IBlockState state = ModBlocks.framedDrawerController.func_176223_P();
        if (!stack.func_77942_o()) {
            return new CustomControllerModel(state, true);
        }
        NBTTagCompound tag = stack.func_77978_p();
        ItemStack matFront = ItemStack.field_190927_a;
        ItemStack matSide = ItemStack.field_190927_a;
        ItemStack matTrim = ItemStack.field_190927_a;
        assert (tag != null);
        if (tag.func_150297_b("MatF", 10)) {
            matFront = new ItemStack(tag.func_74775_l("MatF"));
        }
        if (tag.func_150297_b("MatS", 10)) {
            matSide = new ItemStack(tag.func_74775_l("MatS"));
        }
        if (tag.func_150297_b("MatT", 10)) {
            matTrim = new ItemStack(tag.func_74775_l("MatT"));
        }
        ItemStack effMatFront = !matFront.func_190926_b() ? matFront : matSide;
        ItemStack effMatTrim = !matTrim.func_190926_b() ? matTrim : matSide;
        ItemStack effMatSide = matSide;
        CustomControllerModel model = new CustomControllerModel(state, effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim, true);
        if (!stack.func_77978_p().func_150297_b("tile", 10)) {
            return model;
        }
        return new DrawerSealedModel((IBakedModel)model, state, true);
    }

    protected void renderMippedLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconTrim;
        ItemStack itemFront = (ItemStack)args[0];
        ItemStack itemSide = (ItemStack)args[1];
        ItemStack itemTrim = (ItemStack)args[2];
        TextureAtlasSprite iconFront = !itemFront.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemFront) : null;
        TextureAtlasSprite iconSide = !itemSide.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemSide) : null;
        TextureAtlasSprite textureAtlasSprite = iconTrim = !itemTrim.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemTrim) : null;
        if (iconFront == null) {
            iconFront = iconSide;
        }
        if (iconTrim == null) {
            iconTrim = iconSide;
        }
        if (iconFront == null) {
            iconFront = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultFront);
        }
        if (iconSide == null) {
            iconSide = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        if (iconTrim == null) {
            iconTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        this.iconParticle = iconSide;
        ControllerRenderer controllerRenderer = new ControllerRenderer(renderer);
        controllerRenderer.renderBasePass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconSide, iconTrim, iconFront);
    }

    protected void renderTransLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconOverlayHandle = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayHandle);
        ItemStack matFront = (ItemStack)args[0];
        ItemStack itemTrim = (ItemStack)args[5];
        TextureAtlasSprite iconOverlayFace = matFront.func_190926_b() ? null : Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayFace);
        TextureAtlasSprite iconTrim = !itemTrim.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemTrim) : null;
        TextureAtlasSprite iconOverlayTrim = iconTrim == null ? Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayBoldTrim) : Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayTrim);
        ControllerRenderer controllerRenderer = new ControllerRenderer(renderer);
        controllerRenderer.renderOverlayPass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconOverlayTrim, iconOverlayHandle, iconOverlayFace);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconParticle;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
            return CustomControllerModel.fromItem(stack);
        }
    }

    public static class Model
    extends ProxyBuilderModel {
        public Model() {
            super(Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide));
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            try {
                return CustomControllerModel.fromBlock(state);
            }
            catch (Throwable t) {
                return parent;
            }
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }

        public List<Object> getKey(IBlockState state) {
            try {
                ArrayList<Object> key = new ArrayList<Object>();
                IExtendedBlockState xState = (IExtendedBlockState)state;
                key.add(xState.getValue(BlockDrawersCustom.MAT_MODEL));
                return key;
            }
            catch (Throwable t) {
                return super.getKey(state);
            }
        }
    }

    public static class Register
    extends DefaultRegister<BlockControllerCustom> {
        public static final ResourceLocation iconDefaultSide = new ResourceLocation("framedcompactdrawers:blocks/raw_side");
        public static final ResourceLocation iconDefaultFront = new ResourceLocation("framedcompactdrawers:blocks/drawer_controller_raw_front");
        public static final ResourceLocation iconOverlayTrim = new ResourceLocation("framedcompactdrawers:blocks/overlay/shading_controller_trim");
        public static final ResourceLocation iconOverlayBoldTrim = new ResourceLocation("framedcompactdrawers:blocks/overlay/shading_controller_bold_trim");
        public static final ResourceLocation iconOverlayFace = new ResourceLocation("framedcompactdrawers:blocks/overlay/shading_controller_face");
        public static final ResourceLocation iconOverlayHandle = new ResourceLocation("framedcompactdrawers:blocks/overlay/handle");

        public Register() {
            super((Block)ModBlocks.framedDrawerController);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                states.add(ModBlocks.framedDrawerController.func_176223_P().func_177226_a((IProperty)BlockDrawers.FACING, (Comparable)dir));
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public List<ResourceLocation> getTextureResources() {
            ArrayList<ResourceLocation> resource = new ArrayList<ResourceLocation>();
            resource.add(iconDefaultFront);
            resource.add(iconDefaultSide);
            resource.add(iconOverlayTrim);
            resource.add(iconOverlayBoldTrim);
            resource.add(iconOverlayFace);
            resource.add(iconOverlayHandle);
            return resource;
        }
    }
}

