/*
 * Decompiled with CFR 0.152.
 */
package flavor.pie.spongycord;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.spongepowered.api.Game;
import org.spongepowered.api.Platform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.api.network.RawDataListener;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

@Plugin(id="spongycord", name="SpongyCord", version="1.1.1", authors={"pie_flavor"}, description="A simple wrapper API for Bungee.")
public class SpongyCord {
    @Inject
    Game game;
    Task task;
    private static SpongyCord instance;

    @Listener
    public void preInit(GamePreInitializationEvent e) {
        instance = this;
    }

    @Listener
    public void startingServer(GameStartingServerEvent e) {
        API.channel = this.game.getChannelRegistrar().createRawChannel((Object)this, "BungeeCord");
        API.channel.addListener(Platform.Type.SERVER, (RawDataListener)(API.listener = new API.ChannelListener()));
    }

    @Listener
    public void stoppingServer(GameStoppingServerEvent e) {
        this.game.getChannelRegistrar().unbindChannel((ChannelBinding)API.channel);
    }

    public static class API {
        private static ChannelBinding.RawDataChannel channel;
        private static ChannelListener listener;

        private static void checkChannel() {
            if (channel == null) {
                throw new IllegalStateException("The message channel could not be found!");
            }
        }

        public static void connectPlayer(Player player, String server) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)player);
            Preconditions.checkNotNull((Object)server);
            channel.sendTo(player, buf -> buf.writeUTF("Connect").writeUTF(server));
        }

        public static void connectPlayer(String player, String server, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)player);
            Preconditions.checkNotNull((Object)server);
            Preconditions.checkNotNull((Object)reference);
            channel.sendTo(reference, buf -> buf.writeUTF("ConnectOther").writeUTF(player).writeUTF(server));
        }

        public static void getIP(Player player, Consumer<InetSocketAddress> consumer) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)player);
            Preconditions.checkNotNull(consumer);
            channel.sendTo(player, buf -> buf.writeUTF("IP"));
            API.addListener(buf -> buf.resetRead().readUTF().equals("IP"), buf -> consumer.accept(new InetSocketAddress(buf.readUTF(), buf.readInteger())));
        }

        public static void getPlayerCount(String server, IntConsumer consumer, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)reference);
            Preconditions.checkNotNull((Object)consumer);
            Preconditions.checkNotNull((Object)server);
            channel.sendTo(reference, buf -> buf.writeUTF("PlayerCount").writeUTF(server));
            API.addListener(buf -> buf.resetRead().readUTF().equals("PlayerCount") && buf.readUTF().equals(server), buf -> consumer.accept(buf.readInteger()));
        }

        public static void getGlobalPlayerCount(IntConsumer consumer, Player reference) {
            API.getPlayerCount("ALL", consumer, reference);
        }

        public static void listPlayers(String server, Consumer<List<String>> consumer, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)server);
            Preconditions.checkNotNull((Object)reference);
            channel.sendTo(reference, buf -> buf.writeUTF("PlayerList").writeUTF(server));
            API.addListener(buf -> buf.resetRead().readUTF().equals("PlayerList") && buf.readUTF().equals(server), buf -> consumer.accept((List<String>)ImmutableList.builder().add((Object[])buf.readUTF().split(", ")).build()));
        }

        public static void listAllPlayers(Consumer<List<String>> consumer, Player reference) {
            API.listPlayers("ALL", consumer, reference);
        }

        public static void getServerList(Consumer<List<String>> consumer, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull(consumer);
            Preconditions.checkNotNull((Object)reference);
            channel.sendTo(reference, buf -> buf.writeUTF("GetServers"));
            API.addListener(buf -> buf.resetRead().readUTF().equals("GetServers"), buf -> consumer.accept((List<String>)ImmutableList.builder().add((Object[])buf.readUTF().split(", ")).build()));
        }

        public static void sendMessage(String player, Text message, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)reference);
            Preconditions.checkNotNull((Object)message);
            Preconditions.checkNotNull((Object)player);
            channel.sendTo(reference, buf -> buf.writeUTF("Message").writeUTF(player).writeUTF(TextSerializers.LEGACY_FORMATTING_CODE.serialize(message)));
        }

        public static void getServerName(Consumer<String> consumer, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull(consumer);
            Preconditions.checkNotNull((Object)reference);
            channel.sendTo(reference, buf -> buf.writeUTF("GetServer"));
            API.addListener(buf -> buf.resetRead().readUTF().equals("GetServer"), buf -> consumer.accept(buf.readUTF()));
        }

        public static void sendServerPluginMessage(byte[] message, String channel, String server, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)message);
            Preconditions.checkNotNull((Object)channel);
            Preconditions.checkNotNull((Object)server);
            Preconditions.checkNotNull((Object)reference);
            API.channel.sendTo(reference, buf -> {
                buf.writeUTF("Forward").writeUTF(server).writeUTF(channel).writeShort((short)message.length);
                for (byte b : message) {
                    buf.writeByte(b);
                }
            });
        }

        public static void sendGlobalPluginMessage(byte[] message, String channel, Player reference) {
            API.sendServerPluginMessage(message, channel, "ALL", reference);
        }

        public static void sendPlayerPluginMessage(byte[] message, String channel, String player, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)message);
            Preconditions.checkNotNull((Object)channel);
            Preconditions.checkNotNull((Object)player);
            Preconditions.checkNotNull((Object)reference);
            API.channel.sendTo(reference, buf -> {
                buf.writeUTF("ForwardToPlayer").writeUTF(player).writeUTF(channel).writeShort((short)message.length);
                for (byte b : message) {
                    buf.writeByte(b);
                }
            });
        }

        public static void getRealUUID(Player player, Consumer<UUID> consumer) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)player);
            Preconditions.checkNotNull(consumer);
            channel.sendTo(player, buf -> buf.writeUTF("UUID"));
            API.addListener(buf -> buf.resetRead().readUTF().equals("UUID"), buf -> consumer.accept(UUID.fromString(buf.readUTF())));
        }

        public static void getRealUUID(String player, Consumer<UUID> consumer, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)player);
            Preconditions.checkNotNull(consumer);
            Preconditions.checkNotNull((Object)reference);
            channel.sendTo(reference, buf -> buf.writeUTF("UUIDOther").writeUTF(player));
            API.addListener(buf -> buf.resetRead().readUTF().equals("UUIDOther") && buf.readUTF().equals(player), buf -> consumer.accept(UUID.fromString(buf.readUTF())));
        }

        public static void getServerIP(String server, Consumer<InetSocketAddress> consumer, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull(consumer);
            Preconditions.checkNotNull((Object)reference);
            channel.sendTo(reference, buf -> buf.writeUTF("ServerIP").writeUTF(server));
            API.addListener(buf -> buf.resetRead().readUTF().equals("ServerIP") && buf.readUTF().equals(server), buf -> consumer.accept(new InetSocketAddress(buf.readUTF(), (int)buf.readShort())));
        }

        public static void kickPlayer(String player, Text reason, Player reference) {
            API.checkChannel();
            Preconditions.checkNotNull((Object)player);
            Preconditions.checkNotNull((Object)reason);
            Preconditions.checkNotNull((Object)reference);
            channel.sendTo(reference, buf -> buf.writeUTF("KickPlayer").writeUTF(player).writeUTF(TextSerializers.LEGACY_FORMATTING_CODE.serialize(reason)));
        }

        private static void addListener(Predicate<ChannelBuf> predicate, Consumer<ChannelBuf> consumer) {
            API.listener.map.put(predicate, consumer);
        }

        private static class ChannelListener
        implements RawDataListener {
            ConcurrentMap<Predicate<ChannelBuf>, Consumer<ChannelBuf>> map = Maps.newConcurrentMap();

            private ChannelListener() {
            }

            public void handlePayload(ChannelBuf data, RemoteConnection connection, Platform.Type side) {
                for (Map.Entry entry : this.map.entrySet()) {
                    if (!((Predicate)entry.getKey()).test(data)) continue;
                    ((Consumer)entry.getValue()).accept(data);
                    this.map.remove(entry.getKey());
                    return;
                }
            }
        }
    }
}

