/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.triviaquest;

import com.google.inject.Inject;
import com.mcsimonflash.sponge.triviaquest.commands.AnswerTrivia;
import com.mcsimonflash.sponge.triviaquest.commands.Base;
import com.mcsimonflash.sponge.triviaquest.commands.PostTrivia;
import com.mcsimonflash.sponge.triviaquest.commands.ToggleRunner;
import com.mcsimonflash.sponge.triviaquest.managers.Config;
import com.mcsimonflash.sponge.triviaquest.managers.Trivia;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;

@Plugin(id="triviaquest", name="TriviaQuest", version="2.1.1", description="In-Game Trivia Questions", authors={"Simon_Flash"})
public class TriviaQuest {
    private static TriviaQuest instance;
    private static PluginContainer container;
    private static Logger logger;
    private static URL wiki;
    private static URL discord;

    @Inject
    public TriviaQuest(PluginContainer container) {
        instance = this;
        TriviaQuest.container = container;
        logger = container.getLogger();
    }

    @Listener
    public void onInitilization(GameInitializationEvent event) {
        logger.info("+=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=+");
        logger.info("|     TriviaQuest - Version 2.1.1     |");
        logger.info("|      Developed By: Simon_Flash      |");
        logger.info("+=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=+");
        Config.readConfig();
        try {
            wiki = new URL("https://github.com/SimonFlash/TriviaQuest/wiki");
            discord = new URL("https://discordapp.com/invite/4wayq37");
        }
        catch (MalformedURLException ignored) {
            logger.error("Unable to locate TriviaQuest Wiki / Support Discord!");
        }
        CommandSpec AnswerTrivia2 = CommandSpec.builder().executor((CommandExecutor)new AnswerTrivia()).description((Text)Text.of((String)"Answer a TriviaQuest trivia")).permission("triviaquest.answertrivia.base").arguments(GenericArguments.remainingJoinedStrings((Text)Text.of((String)"answer"))).build();
        CommandSpec PostTrivia2 = CommandSpec.builder().executor((CommandExecutor)new PostTrivia()).description((Text)Text.of((String)"Posts TriviaQuest trivia")).permission("triviaquest.posttrivia.base").build();
        CommandSpec ToggleRunner2 = CommandSpec.builder().executor((CommandExecutor)new ToggleRunner()).description((Text)Text.of((String)"Starts automatic TriviaQuest trivia")).permission("triviaquest.togglerunner.base").build();
        CommandSpec TriviaQuest2 = CommandSpec.builder().executor((CommandExecutor)new Base()).description((Text)Text.of((String)"Opens in-game documentation")).permission("triviaquest.base").child((CommandCallable)AnswerTrivia2, new String[]{"answertrivia", "answer", "ans"}).child((CommandCallable)PostTrivia2, new String[]{"posttrivia", "post", "pt"}).child((CommandCallable)ToggleRunner2, new String[]{"togglerunner", "toggle", "tr"}).build();
        Sponge.getCommandManager().register((Object)instance, (CommandCallable)TriviaQuest2, new String[]{"triviaquest", "trivia", "tq"});
    }

    @Listener
    public void onStart(GameStartingServerEvent event) {
        if (Trivia.runnerEnabled) {
            Trivia.startRunner();
        }
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        Config.readConfig();
        if (Trivia.runnerEnabled) {
            Trivia.startRunner();
        }
    }

    @Listener(order=Order.EARLY)
    public void onMessageSend(MessageChannelEvent.Chat event, @Root Player player) {
        if (Trivia.trivia != null && player.hasPermission("triviaquest.answertrivia.chat") && Trivia.processAnswer((CommandSource)player, event.getRawMessage().toPlain())) {
            event.setMessageCancelled(true);
        }
    }

    public static TriviaQuest getInstance() {
        return instance;
    }

    public static PluginContainer getContainer() {
        return container;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static URL getWiki() {
        return wiki;
    }

    public static URL getDiscord() {
        return discord;
    }
}

