/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.triviaquest.managers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.mcsimonflash.sponge.triviaquest.TriviaQuest;
import com.mcsimonflash.sponge.triviaquest.managers.Trivia;
import com.mcsimonflash.sponge.triviaquest.managers.Util;
import com.mcsimonflash.sponge.triviaquest.objects.Completion;
import com.mcsimonflash.sponge.triviaquest.objects.Question;
import com.mcsimonflash.sponge.triviaquest.objects.Scramble;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;

public class Config {
    private static Path dir = Sponge.getConfigManager().getPluginConfig((Object)TriviaQuest.getContainer()).getDirectory();
    private static Path packs = dir.resolve("packs");
    public static boolean showAnswers;
    public static int chanceSum;
    public static int enableRewardsCount;
    public static int enableTriviaCount;
    public static int triviaInterval;
    public static int triviaLength;
    public static String completionQuestion;
    public static String completionAnswer;
    public static String scrambleQuestion;
    public static String scrambleAnswer;
    public static List<String> enabledPacks;
    public static Map<String, Integer> rewardCommands;

    public static void readConfig() {
        Trivia.trivia = null;
        Trivia.runnerEnabled = false;
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path core = dir.resolve("triviaquest.core");
            ((Asset)TriviaQuest.getContainer().getAsset("triviaquest.core").get()).copyToFile(core);
            if (Files.notExists(packs, new LinkOption[0])) {
                Files.createDirectories(packs, new FileAttribute[0]);
                ((Asset)TriviaQuest.getContainer().getAsset("trivia.pack").get()).copyToFile(packs.resolve("trivia.pack"));
            }
            CommentedConfigurationNode root = (CommentedConfigurationNode)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(core)).build().load();
            enabledPacks = root.getNode(new Object[]{"enabled-packs"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(Collectors.toList());
            enabledPacks.forEach(p -> Config.loadPack(packs.resolve(p + ".pack")));
            root.getNode(new Object[]{"rewards"}).getChildrenMap().values().forEach(r -> rewardCommands.put(r.getNode(new Object[]{"command"}).getString(""), r.getNode(new Object[]{"chance"}).getInt(0)));
            chanceSum = rewardCommands.values().stream().mapToInt(Integer::intValue).sum();
            showAnswers = root.getNode(new Object[]{"config", "show-answers"}).getBoolean(false);
            enableRewardsCount = root.getNode(new Object[]{"config", "enable-rewards-count"}).getInt(0);
            enableTriviaCount = root.getNode(new Object[]{"config", "enable-trivia-count"}).getInt(0);
            triviaInterval = root.getNode(new Object[]{"config", "trivia-interval"}).getInt(300);
            triviaLength = root.getNode(new Object[]{"config", "trivia-length"}).getInt(30);
            if (triviaInterval < 1 || triviaLength < 1) {
                TriviaQuest.getLogger().error("Interval and length must be at least 1! | Interval:[" + triviaInterval + "] Length:[" + triviaLength + "]");
                triviaInterval = 300;
                triviaLength = 30;
            }
            completionQuestion = root.getNode(new Object[]{"config", "completion-question"}).getString("&fFill in the blanks: <word>");
            completionAnswer = root.getNode(new Object[]{"config", "completion-answer"}).getString("&fThe word was &d<word>&f!");
            scrambleQuestion = root.getNode(new Object[]{"config", "scramble-question"}).getString("&fUnscramble the word: <word>");
            scrambleAnswer = root.getNode(new Object[]{"config", "scramble-answer"}).getString("&fThe word was &d<word>&f!");
            Trivia.prefix = Util.toText(root.getNode(new Object[]{"config", "trivia-prefix"}).getString("&8&l[&5TriviaQuest&8&l]&f "));
            if (Trivia.triviaList.isEmpty()) {
                TriviaQuest.getLogger().warn("Trivia list is empty! Adding a silly question.");
                Trivia.triviaList.add(new Question("Ask a silly question, get a _____ answer.", Lists.newArrayList((Object[])new String[]{"silly"})));
            } else if (root.getNode(new Object[]{"config", "enable-on-startup"}).getBoolean(false)) {
                Trivia.runnerEnabled = true;
            }
        }
        catch (IOException e) {
            TriviaQuest.getLogger().error("Config could not be loaded!");
            e.printStackTrace();
        }
    }

    public static void loadPack(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                CommentedConfigurationNode node = (CommentedConfigurationNode)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build().load();
                node.getNode(new Object[]{"trivia", "completions"}).getChildrenMap().values().forEach(n -> Trivia.triviaList.add(new Completion(n.getNode(new Object[]{"word"}).getString(""), Config.getList(path, (ConfigurationNode)n.getNode(new Object[]{"choices"})))));
                node.getNode(new Object[]{"trivia", "questions"}).getChildrenMap().values().forEach(n -> Trivia.triviaList.add(new Question(n.getNode(new Object[]{"question"}).getString(""), Config.getList(path, (ConfigurationNode)n.getNode(new Object[]{"answers"})))));
                node.getNode(new Object[]{"trivia", "scrambles"}).getChildrenMap().values().forEach(n -> Trivia.triviaList.add(new Scramble(n.getNode(new Object[]{"word"}).getString(""), Config.getList(path, (ConfigurationNode)n.getNode(new Object[]{"choices"})))));
            }
            catch (IOException e) {
                TriviaQuest.getLogger().error("Error loading pack " + path.getFileName() + ".");
                e.printStackTrace();
            }
        } else {
            TriviaQuest.getLogger().error("Attempted to load non-existent pack " + path.getFileName() + ".");
        }
    }

    public static List<String> getList(Path path, ConfigurationNode node) {
        try {
            return node.getList(TypeToken.of(String.class));
        }
        catch (ObjectMappingException e) {
            TriviaQuest.getLogger().error("Unable to load list from pack " + path.getFileName() + " at " + Arrays.toString(node.getPath()));
            return Lists.newArrayList();
        }
    }

    static {
        enabledPacks = Lists.newArrayList();
        rewardCommands = Maps.newHashMap();
    }
}

