/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.triviaquest.managers;

import com.google.common.collect.Lists;
import com.mcsimonflash.sponge.triviaquest.TriviaQuest;
import com.mcsimonflash.sponge.triviaquest.managers.Config;
import com.mcsimonflash.sponge.triviaquest.managers.Util;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;

public class Trivia {
    public static Text prefix;
    public static boolean runnerEnabled;
    public static int triviaIndex;
    public static Task runnerTask;
    public static com.mcsimonflash.sponge.triviaquest.objects.Trivia trivia;
    public static List<com.mcsimonflash.sponge.triviaquest.objects.Trivia> triviaList;

    public static void startRunner() {
        if (runnerTask != null) {
            runnerTask.cancel();
        }
        runnerTask = Task.builder().name("TriviaRunner").execute(t -> Trivia.askQuestion(false)).delay((long)Config.triviaInterval, TimeUnit.SECONDS).submit((Object)TriviaQuest.getInstance());
    }

    public static void newQuestion() {
        if (triviaIndex == 0) {
            triviaIndex = triviaList.size();
            Collections.shuffle(triviaList);
        }
        trivia = triviaList.get(--triviaIndex);
    }

    public static void askQuestion(boolean override) {
        if (Trivia.shouldTriviaRun(override) && trivia == null) {
            Trivia.newQuestion();
            Sponge.getServer().getBroadcastChannel().send(prefix.concat(Util.toText(trivia.getQuestion())));
            runnerTask = Task.builder().execute(t -> Trivia.closeQuestion(false)).name("Question").delay((long)Config.triviaLength, TimeUnit.SECONDS).submit((Object)TriviaQuest.getInstance());
        } else if (runnerEnabled) {
            Trivia.startRunner();
        }
    }

    public static void closeQuestion(boolean answered) {
        if (!answered) {
            Sponge.getServer().getBroadcastChannel().send(prefix.concat(Util.toText("Times up! " + (Config.showAnswers ? trivia.getAnswer() : "Better luck next time!"))));
        }
        trivia = null;
        if (runnerTask != null) {
            runnerTask.cancel();
        }
        if (runnerEnabled) {
            Trivia.startRunner();
        }
    }

    public static boolean shouldTriviaRun(boolean override) {
        if (override) {
            return true;
        }
        if (!runnerEnabled) {
            return false;
        }
        return Sponge.getServer().getOnlinePlayers().size() >= Config.enableTriviaCount;
    }

    public static boolean processAnswer(CommandSource src, String answer) {
        if (trivia.checkAnswer(answer)) {
            String rewardCmd;
            Sponge.getServer().getBroadcastChannel().send(prefix.concat(Util.toText("&d" + src.getName() + "&f got it! " + (Config.showAnswers ? trivia.getAnswer() : "Better luck next time!"))));
            if (Sponge.getServer().getOnlinePlayers().size() >= Config.enableRewardsCount && (rewardCmd = (String)Util.getReward().orElse(null)) != null && !rewardCmd.isEmpty()) {
                if (src instanceof Player) {
                    Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), rewardCmd.replace("<player>", src.getName()));
                } else {
                    src.sendMessage(prefix.concat(Util.toText("Sorry! Only a player can receive a reward!")));
                }
            }
            Trivia.closeQuestion(true);
            return true;
        }
        return false;
    }

    static {
        runnerEnabled = false;
        triviaIndex = 0;
        trivia = null;
        triviaList = Lists.newArrayList();
    }
}

