/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict.Commands;

import java.util.ArrayList;
import java.util.Optional;
import net.moddedminecraft.mmcrestrict.Config.Config;
import net.moddedminecraft.mmcrestrict.Data.ModData;
import net.moddedminecraft.mmcrestrict.Main;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class Mod
implements CommandExecutor {
    private final Main plugin;

    public Mod(Main plugin) {
        this.plugin = plugin;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional modOp = args.getOne("Mod");
        if (!(src instanceof Player)) {
            throw new CommandException((Text)Text.of((String)"Console users cannot use this command"));
        }
        Player player = (Player)src;
        if (!modOp.isPresent()) {
            throw new CommandException(this.plugin.fromLegacy("&cUsage: /restrict mod (modid)"));
        }
        String modArg = (String)modOp.get();
        ArrayList<ModData> mods = new ArrayList<ModData>(this.plugin.getModData());
        if (!mods.isEmpty()) {
            for (ModData mod : mods) {
                if (!mod.getMod().equals(modArg)) continue;
                throw new CommandException((Text)Text.of((String)"Mod already exists"));
            }
        }
        this.plugin.addMod(new ModData(Config.defaultHidden, modArg, modArg, Config.defaultReason, Config.defaultUsage, Config.defaultBreaking, Config.defaultPlacing, Config.defaultOwnership, Config.defaultDrop, Config.defaultCraft));
        try {
            this.plugin.saveData();
        }
        catch (Exception e) {
            player.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
            e.printStackTrace();
        }
        this.plugin.logToFile("ban-list", player.getName() + " added the " + modArg + " mod to the ban list");
        player.sendMessage((Text)Text.of((String)(modArg + " mod was added to the list.")));
        return CommandResult.success();
    }
}

