/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.Collection;
import java.util.Objects;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.nbt.NBTTagCompound;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class ModuleSatellite
extends LogisticsModule {
    private final CoreRoutedPipe pipe;
    private SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, null);

    public ModuleSatellite(CoreRoutedPipe pipeItemsSatelliteLogistics) {
        this.pipe = pipeItemsSatelliteLogistics;
    }

    @Override
    public void registerHandler(IWorldProvider world, IPipeServiceProvider service) {
    }

    @Override
    public final int getX() {
        return this.pipe.getX();
    }

    @Override
    public final int getY() {
        return this.pipe.getY();
    }

    @Override
    public final int getZ() {
        return this.pipe.getZ();
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        return new SinkReply(this._sinkReply, this.spaceFor(item, includeInTransit));
    }

    private int spaceFor(ItemIdentifier item, boolean includeInTransit) {
        WorldCoordinatesWrapper worldCoordinates = new WorldCoordinatesWrapper(this.pipe.container);
        int count = worldCoordinates.connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).map(adjacent -> adjacent.sneakyInsertion().from(this.getUpgradeManager())).map(NeighborTileEntity::getInventoryUtil).filter(Objects::nonNull).map(util -> util.roomForItem(item, 9999)).reduce(Integer::sum).orElse(0);
        if (includeInTransit) {
            count -= this.pipe.countOnRoute(item);
        }
        return count;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public Collection<ItemIdentifier> getSpecificInterests() {
        return this.pipe.getSpecificInterests();
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }
}

