/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules.abstractmodules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IQueueCCEvent;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.ISaveState;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.proxy.computers.objects.CCSinkResponder;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;

@CCType(name="LogisticsModule")
public abstract class LogisticsModule
implements ISaveState,
ILPCCTypeHolder {
    private Object ccType;
    protected IWorldProvider _world;
    protected IPipeServiceProvider _service;
    protected ModulePositionType slot;
    protected int positionInt;

    public void registerHandler(IWorldProvider world, IPipeServiceProvider service) {
        this._world = world;
        this._service = service;
    }

    public void registerPosition(ModulePositionType slot, int positionInt) {
        this.slot = slot;
        this.positionInt = positionInt;
    }

    public abstract int getX();

    public abstract int getY();

    public abstract int getZ();

    public abstract SinkReply sinksItem(ItemIdentifier var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

    public abstract LogisticsModule getSubModule(int var1);

    public abstract void tick();

    public abstract boolean hasGenericInterests();

    public abstract Collection<ItemIdentifier> getSpecificInterests();

    public abstract boolean interestedInAttachedInventory();

    public abstract boolean interestedInUndamagedID();

    public abstract boolean recievePassive();

    public boolean hasEffect() {
        return false;
    }

    public List<CCSinkResponder> queueCCSinkEvent(ItemIdentifierStack item) {
        return new ArrayList<CCSinkResponder>(0);
    }

    public void registerCCEventQueuer(IQueueCCEvent eventQueuer) {
    }

    @CCCommand(description="Returns if the Pipe has a gui")
    public boolean hasGui() {
        return false;
    }

    public String toString() {
        return String.format("%s@(%d, %d, %d)", this.getClass().getSimpleName(), this.getX(), this.getY(), this.getZ());
    }

    @Nullable
    protected ISlotUpgradeManager getUpgradeManager() {
        if (this._service == null) {
            return null;
        }
        return this._service.getUpgradeManager(this.slot, this.positionInt);
    }

    public void clearCache() {
    }

    @Override
    public void setCCType(Object type) {
        this.ccType = type;
    }

    @Override
    public Object getCCType() {
        return this.ccType;
    }

    public ModulePositionType getSlot() {
        return this.slot;
    }

    public int getPositionInt() {
        return this.positionInt;
    }

    public static enum ModulePositionType {
        SLOT(true),
        IN_HAND(false),
        IN_PIPE(true);

        private final boolean inWorld;

        private ModulePositionType(boolean inWorld) {
            this.inWorld = inWorld;
        }

        public boolean isInWorld() {
            return this.inWorld;
        }
    }
}

