/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import logisticspipes.LogisticsPipes;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractguis.PopupGuiProvider;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.network.packets.gui.OpenGUIPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolverUtil;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SubGuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.util.LPDataIOWrapper;

public class NewGuiHandler {
    public static List<GuiProvider> guilist;
    public static Map<Class<? extends GuiProvider>, GuiProvider> guimap;

    private NewGuiHandler() {
    }

    public static <T extends GuiProvider> T getGui(Class<T> clazz) {
        return (T)guimap.get(clazz).template();
    }

    public static void initialize() {
        Set<Class<? extends GuiProvider>> classes = StaticResolverUtil.findClassesByType(GuiProvider.class);
        NewGuiHandler.loadGuiProviders(classes);
        if (guilist == null || guilist.isEmpty()) {
            throw new RuntimeException("Cannot load GuiProvider Classes");
        }
    }

    private static void loadGuiProviders(Set<Class<? extends GuiProvider>> classesIn) {
        List classes = classesIn.stream().sorted(Comparator.comparing(Class::getCanonicalName)).collect(Collectors.toList());
        guilist = new ArrayList<GuiProvider>(classes.size());
        guimap = new HashMap<Class<? extends GuiProvider>, GuiProvider>(classes.size());
        int currentId = 0;
        for (Class cls : classes) {
            try {
                GuiProvider instance = (GuiProvider)cls.getConstructors()[0].newInstance(currentId);
                guilist.add(instance);
                guimap.put(cls, instance);
                ++currentId;
            }
            catch (Throwable ignoredButPrinted) {
                ignoredButPrinted.printStackTrace();
            }
        }
    }

    public static void openGui(GuiProvider guiProvider, EntityPlayer oPlayer) {
        if (!(oPlayer instanceof EntityPlayerMP)) {
            throw new UnsupportedOperationException("Gui can only be opened on the server side");
        }
        EntityPlayerMP player = (EntityPlayerMP)oPlayer;
        Container container = guiProvider.getContainer((EntityPlayer)player);
        if (container == null) {
            if (guiProvider instanceof PopupGuiProvider) {
                OpenGUIPacket packet = PacketHandler.getPacket(OpenGUIPacket.class);
                packet.setGuiID(guiProvider.getId());
                packet.setWindowID(-2);
                packet.setGuiData(LPDataIOWrapper.collectData(guiProvider::writeData));
                MainProxy.sendPacketToPlayer(packet, (EntityPlayer)player);
            }
            return;
        }
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        OpenGUIPacket packet = PacketHandler.getPacket(OpenGUIPacket.class);
        packet.setGuiID(guiProvider.getId());
        packet.setWindowID(windowId);
        packet.setGuiData(LPDataIOWrapper.collectData(guiProvider::writeData));
        MainProxy.sendPacketToPlayer(packet, (EntityPlayer)player);
        player.field_71070_bA = container;
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, player.field_71070_bA));
    }

    @SideOnly(value=Side.CLIENT)
    public static void openGui(OpenGUIPacket packet, EntityPlayer player) {
        int guiID = packet.getGuiID();
        GuiProvider provider = guilist.get(guiID).template();
        LPDataIOWrapper.provideData(packet.getGuiData(), provider::readData);
        if (provider instanceof PopupGuiProvider && packet.getWindowID() == -2) {
            if (FMLClientHandler.instance().getClient().field_71462_r instanceof LogisticsBaseGuiScreen) {
                SubGuiScreen newSub;
                LogisticsBaseGuiScreen baseGUI = (LogisticsBaseGuiScreen)FMLClientHandler.instance().getClient().field_71462_r;
                try {
                    newSub = (SubGuiScreen)provider.getClientGui(player);
                }
                catch (TargetNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    LogisticsPipes.log.error(packet.getClass().getName());
                    LogisticsPipes.log.error(packet.toString());
                    throw new RuntimeException(e);
                }
                if (newSub != null) {
                    if (!baseGUI.hasSubGui()) {
                        baseGUI.setSubGui(newSub);
                    } else {
                        SubGuiScreen canidate = baseGUI.getSubGui();
                        while (canidate.hasSubGui()) {
                            canidate = canidate.getSubGui();
                        }
                        canidate.setSubGui(newSub);
                    }
                }
            }
        } else {
            GuiContainer screen;
            try {
                screen = (GuiContainer)provider.getClientGui(player);
            }
            catch (TargetNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                LogisticsPipes.log.error(packet.getClass().getName());
                LogisticsPipes.log.error(packet.toString());
                throw new RuntimeException(e);
            }
            screen.field_147002_h.field_75152_c = packet.getWindowID();
            FMLCommonHandler.instance().showGuiScreen((Object)screen);
        }
    }
}

