/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class UpdateName
extends ModernPacket {
    private ItemIdentifier ident;
    private String name;

    public UpdateName(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new UpdateName(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (MainProxy.isClient((IBlockAccess)player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(UpdateName.class).setIdent(this.getIdent()).setName(this.getIdent().getFriendlyName()));
        } else {
            MainProxy.proxy.updateNames(this.getIdent(), this.getName());
        }
    }

    @Override
    public void readData(LPDataInput input) {
        this.ident = input.readItemIdentifierStack().getItem();
        this.name = input.readUTF();
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeItemIdentifierStack(this.ident.makeStack(1));
        output.writeUTF(this.name);
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public ItemIdentifier getIdent() {
        return this.ident;
    }

    public UpdateName setIdent(ItemIdentifier ident) {
        this.ident = ident;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public UpdateName setName(String name) {
        this.name = name;
        return this;
    }
}

