/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class DSUInventoryHandler
extends SpecialInventoryHandler {
    private final IDeepStorageUnit _tile;
    private final boolean _hideOnePerStack;

    private DSUInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = (IDeepStorageUnit)tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public DSUInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile, EnumFacing dir) {
        return tile instanceof IDeepStorageUnit;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new DSUInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        ItemStack items = this._tile.getStoredItemType();
        if (!items.func_190926_b() && ItemIdentifier.get(items).equals(itemIdent)) {
            return items.func_190916_E() - (this._hideOnePerStack ? 1 : 0);
        }
        return 0;
    }

    @Override
    @Nonnull
    public ItemStack getMultipleItems(ItemIdentifier itemIdent, int count) {
        ItemStack items = this._tile.getStoredItemType();
        if (items.func_190926_b() || !ItemIdentifier.get(items).equals(itemIdent)) {
            return ItemStack.field_190927_a;
        }
        if (this._hideOnePerStack) {
            items.func_190918_g(1);
        }
        if (count >= items.func_190916_E()) {
            this._tile.setStoredItemCount(this._hideOnePerStack ? 1 : 0);
            return items;
        }
        ItemStack newItems = items.func_77979_a(count);
        this._tile.setStoredItemCount(items.func_190916_E() + (this._hideOnePerStack ? 1 : 0));
        return newItems;
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        ItemStack items = this._tile.getStoredItemType();
        if (!items.func_190926_b()) {
            result.add(ItemIdentifier.get(items));
        }
        return result;
    }

    public HashMap<ItemIdentifier, Integer> getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> result = new HashMap<ItemIdentifier, Integer>();
        ItemStack items = this._tile.getStoredItemType();
        if (!items.func_190926_b()) {
            result.put(ItemIdentifier.get(items), items.func_190916_E() - (this._hideOnePerStack ? 1 : 0));
        }
        return result;
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        return this.getMultipleItems(itemIdent, 1);
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        ItemStack items = this._tile.getStoredItemType();
        return !items.func_190926_b() && ItemIdentifier.get(items).getUndamaged().equals(itemIdent);
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        if (itemIdent.tag != null) {
            return 0;
        }
        ItemStack items = this._tile.getStoredItemType();
        if (items.func_190926_b()) {
            return this._tile.getMaxStoredCount();
        }
        if (ItemIdentifier.get(items).equals(itemIdent)) {
            return this._tile.getMaxStoredCount() - items.func_190916_E();
        }
        return 0;
    }

    @Override
    public ItemStack add(ItemStack stack, EnumFacing from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.func_190920_e(0);
        if (stack.func_77978_p() != null) {
            return st;
        }
        ItemStack items = this._tile.getStoredItemType();
        if (items.func_190926_b()) {
            if (stack.func_190916_E() <= this._tile.getMaxStoredCount()) {
                this._tile.setStoredItemType(stack, stack.func_190916_E());
                st.func_190920_e(stack.func_190916_E());
                return st;
            }
            this._tile.setStoredItemType(stack, this._tile.getMaxStoredCount());
            st.func_190920_e(this._tile.getMaxStoredCount());
            return st;
        }
        if (!items.func_77969_a(stack)) {
            return st;
        }
        if (stack.func_190916_E() <= this._tile.getMaxStoredCount() - items.func_190916_E()) {
            this._tile.setStoredItemCount(items.func_190916_E() + stack.func_190916_E());
            st.func_190920_e(stack.func_190916_E());
            return st;
        }
        this._tile.setStoredItemCount(this._tile.getMaxStoredCount());
        st.func_190920_e(this._tile.getMaxStoredCount() - items.func_190916_E());
        return st;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        return this._tile.getStoredItemType();
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int slot, int amount) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        return this.getMultipleItems(ItemIdentifier.get(this._tile.getStoredItemType()), amount);
    }
}

