/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.ISmartGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;

public class StorageDrawersInventoryHandler
extends SpecialInventoryHandler {
    private final IDrawerGroup _drawer;
    private final ISmartGroup _smartGroup;
    private final boolean _hideOnePerStack;
    private final boolean _hideOnePerType;

    private StorageDrawersInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._drawer = (IDrawerGroup)tile;
        this._smartGroup = this._drawer instanceof ISmartGroup ? (ISmartGroup)this._drawer : null;
        this._hideOnePerStack = hideOnePerStack;
        this._hideOnePerType = hideOne;
    }

    public StorageDrawersInventoryHandler() {
        this._drawer = null;
        this._smartGroup = null;
        this._hideOnePerStack = false;
        this._hideOnePerType = false;
    }

    @Override
    public boolean init() {
        List modList = Loader.instance().getModList();
        for (ModContainer mod : modList) {
            if (!mod.getModId().equals("StorageDrawers")) continue;
            try {
                VersionRange validVersions = VersionRange.createFromVersionSpec((String)"[1.7.8,)");
                DefaultArtifactVersion version = new DefaultArtifactVersion(mod.getVersion());
                return validVersions.containsVersion((ArtifactVersion)version);
            }
            catch (InvalidVersionSpecificationException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isType(TileEntity tile, EnumFacing dir) {
        return tile instanceof IDrawerGroup;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new StorageDrawersInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        int count = 0;
        boolean first = true;
        if (this._smartGroup != null) {
            ItemStack protoStack = itemIdent.makeNormalStack(1);
            Iterator iterator = this._smartGroup.enumerateDrawersForExtraction(protoStack, true).iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                IDrawer drawer = this._drawer.getDrawer(slot);
                if (drawer.isEmpty() || !ItemIdentifier.get(drawer.getStoredItemPrototype()).equals(itemIdent)) continue;
                count += drawer.getStoredItemCount() - (this._hideOnePerStack || this._hideOnePerType && first ? 1 : 0);
                first = false;
            }
            return count;
        }
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty() || !ItemIdentifier.get(drawer.getStoredItemPrototype()).equals(itemIdent)) continue;
            count += drawer.getStoredItemCount() - (this._hideOnePerStack || this._hideOnePerType && first ? 1 : 0);
            first = false;
        }
        return count;
    }

    @Override
    @Nonnull
    public ItemStack getMultipleItems(ItemIdentifier itemIdent, int count) {
        ItemStack stack = ItemStack.field_190927_a;
        if (this._smartGroup != null) {
            ItemStack protoStack = itemIdent.makeNormalStack(1);
            Iterator iterator = this._smartGroup.enumerateDrawersForExtraction(protoStack, true).iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                IDrawer drawer = this._drawer.getDrawer(slot);
                if (drawer.isEmpty() || !ItemIdentifier.get(drawer.getStoredItemPrototype()).equals(itemIdent)) continue;
                if (stack.func_190926_b()) {
                    stack = drawer.getStoredItemCopy();
                    stack.func_190920_e(0);
                }
                int avail = Math.min(count, drawer.getStoredItemCount());
                drawer.setStoredItemCount(drawer.getStoredItemCount() - avail);
                stack.func_190917_f(avail);
                if ((count -= avail) > 0) continue;
                break;
            }
            return stack;
        }
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty() || !ItemIdentifier.get(drawer.getStoredItemPrototype()).equals(itemIdent)) continue;
            if (stack.func_190926_b()) {
                stack = drawer.getStoredItemCopy();
                stack.func_190920_e(0);
            }
            int avail = Math.min(count, drawer.getStoredItemCount());
            drawer.setStoredItemCount(drawer.getStoredItemCount() - avail);
            stack.func_190917_f(avail);
            if ((count -= avail) <= 0) break;
        }
        return stack;
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty()) continue;
            result.add(ItemIdentifier.get(drawer.getStoredItemPrototype()));
        }
        return result;
    }

    public HashMap<ItemIdentifier, Integer> getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> result = new HashMap<ItemIdentifier, Integer>();
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            int count;
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty() || (count = drawer.getStoredItemCount()) <= 0) continue;
            ItemIdentifier ident = ItemIdentifier.get(drawer.getStoredItemPrototype());
            if (result.containsKey(ident)) {
                result.put(ident, result.get(ident) + count);
                continue;
            }
            result.put(ident, count);
        }
        return result;
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        return this.getMultipleItems(itemIdent, 1);
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        if (this._smartGroup != null) {
            int slot;
            ItemStack stack = itemIdent.makeNormalStack(1);
            BitSet set = new BitSet();
            Iterator iterator = this._smartGroup.enumerateDrawersForInsertion(stack, true).iterator();
            while (iterator.hasNext()) {
                slot = (Integer)iterator.next();
                set.set(slot);
            }
            iterator = this._smartGroup.enumerateDrawersForExtraction(stack, true).iterator();
            while (iterator.hasNext()) {
                slot = (Integer)iterator.next();
                set.set(slot);
            }
            int slot2 = -1;
            while ((slot2 = set.nextSetBit(slot2 + 1)) != -1) {
                IDrawer drawer = this._drawer.getDrawer(slot2);
                if (drawer.isEmpty() || !ItemIdentifier.get(drawer.getStoredItemPrototype()).getUndamaged().equals(itemIdent)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty() || !ItemIdentifier.get(drawer.getStoredItemPrototype()).getUndamaged().equals(itemIdent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        int room = 0;
        ItemStack protoStack = itemIdent.makeNormalStack(1);
        if (this._smartGroup != null) {
            int slot;
            BitSet set = new BitSet();
            Iterator iterator = this._smartGroup.enumerateDrawersForInsertion(protoStack, false).iterator();
            while (iterator.hasNext()) {
                slot = (Integer)iterator.next();
                set.set(slot);
            }
            iterator = this._smartGroup.enumerateDrawersForExtraction(protoStack, false).iterator();
            while (iterator.hasNext()) {
                slot = (Integer)iterator.next();
                set.set(slot);
            }
            int slot2 = -1;
            while ((slot2 = set.nextSetBit(slot2 + 1)) != -1) {
                IDrawer drawer = this._drawer.getDrawer(slot2);
                room = !drawer.isEmpty() ? (drawer instanceof IVoidable && ((IVoidable)drawer).isVoid() ? (room += drawer.getMaxCapacity()) : (room += drawer.getRemainingCapacity())) : (room += drawer.getMaxCapacity(protoStack));
                if (count == 0 || room < count) continue;
                return count;
            }
            return room;
        }
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null) continue;
            if (drawer.canItemBeStored(protoStack)) {
                room = drawer.isEmpty() ? (room += drawer.getMaxCapacity(protoStack)) : (drawer instanceof IVoidable && ((IVoidable)drawer).isVoid() ? (room += drawer.getMaxCapacity()) : (room += drawer.getRemainingCapacity()));
            }
            if (count == 0 || room < count) continue;
            return count;
        }
        return room;
    }

    @Override
    public ItemStack add(ItemStack stack, EnumFacing from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.func_190920_e(0);
        if (this._smartGroup != null) {
            int slot;
            BitSet set = new BitSet();
            Iterator iterator = this._smartGroup.enumerateDrawersForInsertion(stack, false).iterator();
            while (iterator.hasNext()) {
                slot = (Integer)iterator.next();
                set.set(slot);
            }
            iterator = this._smartGroup.enumerateDrawersForExtraction(stack, false).iterator();
            while (iterator.hasNext()) {
                slot = (Integer)iterator.next();
                set.set(slot);
            }
            int slot2 = -1;
            while ((slot2 = set.nextSetBit(slot2 + 1)) != -1) {
                int avail;
                IDrawer drawer = this._drawer.getDrawer(slot2);
                if (!drawer.isEmpty()) {
                    avail = Math.min(stack.func_190916_E(), drawer.getRemainingCapacity());
                    if (doAdd) {
                        drawer.setStoredItemCount(drawer.getStoredItemCount() + avail);
                    }
                } else {
                    avail = Math.min(stack.func_190916_E(), drawer.getMaxCapacity(stack));
                    if (doAdd) {
                        drawer.setStoredItem(stack, avail);
                    }
                }
                if (drawer instanceof IVoidable && ((IVoidable)drawer).isVoid()) {
                    return stack;
                }
                stack.func_190918_g(avail);
                st.func_190917_f(avail);
                if (stack.func_190916_E() > 0) continue;
                break;
            }
            return st;
        }
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            int avail;
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || !drawer.canItemBeStored(stack)) continue;
            if (drawer.isEmpty()) {
                avail = Math.min(stack.func_190916_E(), drawer.getMaxCapacity(stack));
                if (doAdd) {
                    drawer.setStoredItem(stack.func_77946_l(), avail);
                }
            } else {
                avail = Math.min(stack.func_190916_E(), drawer.getRemainingCapacity());
                if (doAdd) {
                    drawer.setStoredItemCount(drawer.getStoredItemCount() + avail);
                }
            }
            if (drawer instanceof IVoidable && ((IVoidable)drawer).isVoid()) {
                return stack;
            }
            stack.func_190918_g(avail);
            st.func_190917_f(avail);
            if (stack.func_190916_E() <= 0) break;
        }
        return st;
    }

    @Override
    public int getSizeInventory() {
        return this._drawer.getDrawerCount();
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int i) {
        if (!this._drawer.isDrawerEnabled(i)) {
            return ItemStack.field_190927_a;
        }
        return this._drawer.getDrawer(i) != null ? this._drawer.getDrawer(i).getStoredItemCopy() : ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int i, int j) {
        if (!this._drawer.isDrawerEnabled(i)) {
            return ItemStack.field_190927_a;
        }
        IDrawer drawer = this._drawer.getDrawer(i);
        if (drawer == null || drawer.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = drawer.getStoredItemCopy();
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int avail = Math.min(j, drawer.getStoredItemCount());
        drawer.setStoredItemCount(drawer.getStoredItemCount() - avail);
        stack.func_190920_e(avail);
        return stack;
    }
}

