/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import logisticspipes.config.Configs;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.PowerPacketLaser;
import logisticspipes.pipefxhandlers.PipeFXLaserPowerBall;
import logisticspipes.pipefxhandlers.PipeFXLaserPowerBeam;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class LogisticsTileRenderController {
    private static final int LASER_TIMEOUT_TICKS = 4;
    private final LogisticsTileGenericPipe pipe;
    private final Map<LaserKey, LaserBeamData> powerLasersBeam = new HashMap<LaserKey, LaserBeamData>();
    private final Map<Integer, LaserBallData> powerLasersBall = new HashMap<Integer, LaserBallData>();

    public LogisticsTileRenderController(LogisticsTileGenericPipe pipe) {
        this.pipe = pipe;
    }

    public void onUpdate() {
        Object data;
        Object key;
        Iterator<Object> iter = this.powerLasersBeam.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            data = this.powerLasersBeam.get(key);
            ((LaserBeamData)data).tick();
            if (((LaserBeamData)data).timeout >= 0 && !((LaserBeamData)data).isDeadEntity()) continue;
            ((LaserBeamData)data).setDead();
            if (((LaserBeamData)data).sendPacket()) {
                MainProxy.sendPacketToAllWatchingChunk(this.pipe.getX(), this.pipe.getZ(), this.pipe.func_145831_w().field_73011_w.getDimension(), PacketHandler.getPacket(PowerPacketLaser.class).setColor(((LaserKey)key).color).setRenderBall(false).setDir(((LaserKey)key).dir).setRemove(true).setTilePos(this.pipe));
            }
            iter.remove();
        }
        iter = this.powerLasersBall.keySet().iterator();
        while (iter.hasNext()) {
            key = (Integer)iter.next();
            data = this.powerLasersBall.get(key);
            ((LaserBallData)data).tick();
            if (((LaserBallData)data).timeout >= 0 && !((LaserBallData)data).isDeadEntity()) continue;
            ((LaserBallData)data).setDead();
            if (((LaserBallData)data).sendPacket()) {
                MainProxy.sendPacketToAllWatchingChunk(this.pipe.getX(), this.pipe.getZ(), this.pipe.func_145831_w().field_73011_w.getDimension(), PacketHandler.getPacket(PowerPacketLaser.class).setColor((Integer)key).setRenderBall(true).setDir(null).setRemove(true).setTilePos(this.pipe));
            }
            iter.remove();
        }
    }

    public void addLaser(EnumFacing dir, float length, int color, boolean reverse, boolean renderBall) {
        if (!Configs.ENABLE_PARTICLE_FX) {
            return;
        }
        boolean sendPacket = false;
        if (this.powerLasersBeam.containsKey(new LaserKey(dir, color))) {
            this.powerLasersBeam.get((Object)new LaserKey((EnumFacing)dir, (int)color)).timeout = 4;
        } else if (MainProxy.isClient((IBlockAccess)this.pipe.func_145831_w())) {
            this.powerLasersBeam.put(new LaserKey(dir, color), new LaserBeamDataClient(length, 4, reverse, dir, color));
        } else {
            this.powerLasersBeam.put(new LaserKey(dir, color), new LaserBeamData(length, 4, reverse));
            sendPacket = true;
        }
        if (renderBall) {
            if (this.powerLasersBall.containsKey(color)) {
                this.powerLasersBall.get((Object)Integer.valueOf((int)color)).timeout = 4;
            } else if (MainProxy.isClient((IBlockAccess)this.pipe.func_145831_w())) {
                this.powerLasersBall.put(color, new LaserBallDataClient(length, 4, color));
            } else {
                this.powerLasersBall.put(color, new LaserBallData(length, 4));
                sendPacket = true;
            }
        }
        if (sendPacket) {
            MainProxy.sendPacketToAllWatchingChunk(this.pipe.getX(), this.pipe.getZ(), this.pipe.func_145831_w().field_73011_w.getDimension(), PacketHandler.getPacket(PowerPacketLaser.class).setColor(color).setRenderBall(renderBall).setDir(dir).setLength(length).setReverse(reverse).setTilePos(this.pipe));
        }
    }

    public void removeLaser(EnumFacing dir, int color, boolean isBall) {
        if (!MainProxy.isClient((IBlockAccess)this.pipe.func_145831_w())) {
            return;
        }
        if (!isBall) {
            LaserKey key = new LaserKey(dir, color);
            LaserBeamData beam = this.powerLasersBeam.get(key);
            if (beam != null) {
                beam.timeout = -1;
                if (MainProxy.isClient((IBlockAccess)this.pipe.func_145831_w())) {
                    ((LaserBeamDataClient)beam).entity.func_187112_i();
                }
                this.powerLasersBeam.remove(key);
            }
        } else {
            LaserBallData ball = this.powerLasersBall.get(color);
            if (ball != null) {
                ball.timeout = -1;
                if (MainProxy.isClient((IBlockAccess)this.pipe.func_145831_w())) {
                    ((LaserBallDataClient)ball).entity.func_187112_i();
                }
                this.powerLasersBall.remove(color);
            }
        }
    }

    public void sendInit() {
        for (LaserKey key : this.powerLasersBeam.keySet()) {
            LaserBeamData data = this.powerLasersBeam.get(key);
            boolean isBall = this.powerLasersBall.containsKey(key.color);
            MainProxy.sendPacketToAllWatchingChunk(this.pipe.getX(), this.pipe.getZ(), this.pipe.func_145831_w().field_73011_w.getDimension(), PacketHandler.getPacket(PowerPacketLaser.class).setColor(key.color).setRenderBall(isBall).setDir(key.dir).setLength(data.length).setReverse(data.reverse).setTilePos(this.pipe));
        }
    }

    private class LaserBallDataClient
    extends LaserBallData {
        @SideOnly(value=Side.CLIENT)
        final PipeFXLaserPowerBall entity;

        public LaserBallDataClient(float length, int timeout, int color) {
            super(length, timeout);
            this.entity = new PipeFXLaserPowerBall(LogisticsTileRenderController.this.pipe.func_145831_w(), new DoubleCoordinates(LogisticsTileRenderController.this.pipe), color, LogisticsTileRenderController.this.pipe);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)this.entity);
        }

        @Override
        boolean isDeadEntity() {
            return this.entity == null || !this.entity.func_187113_k();
        }

        @Override
        void setDead() {
            if (this.entity != null) {
                this.entity.func_187112_i();
            }
        }

        @Override
        boolean sendPacket() {
            return false;
        }

        @Override
        void tick() {
        }

        public PipeFXLaserPowerBall getEntity() {
            return this.entity;
        }
    }

    private static class LaserBallData {
        final float length;
        int timeout;

        boolean isDeadEntity() {
            return false;
        }

        void setDead() {
        }

        boolean sendPacket() {
            return true;
        }

        void tick() {
            --this.timeout;
        }

        public float getLength() {
            return this.length;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public LaserBallData setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LaserBallData)) {
                return false;
            }
            LaserBallData other = (LaserBallData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getLength(), other.getLength()) != 0) {
                return false;
            }
            return this.getTimeout() == other.getTimeout();
        }

        protected boolean canEqual(Object other) {
            return other instanceof LaserBallData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getLength());
            result = result * 59 + this.getTimeout();
            return result;
        }

        public String toString() {
            return "LogisticsTileRenderController.LaserBallData(length=" + this.getLength() + ", timeout=" + this.getTimeout() + ")";
        }

        @ConstructorProperties(value={"length", "timeout"})
        public LaserBallData(float length, int timeout) {
            this.length = length;
            this.timeout = timeout;
        }
    }

    private class LaserBeamDataClient
    extends LaserBeamData {
        @SideOnly(value=Side.CLIENT)
        final PipeFXLaserPowerBeam entity;

        public LaserBeamDataClient(float length, int timeout, boolean reverse, EnumFacing dir, int color) {
            super(length, timeout, reverse);
            this.entity = new PipeFXLaserPowerBeam(LogisticsTileRenderController.this.pipe.func_145831_w(), new DoubleCoordinates(LogisticsTileRenderController.this.pipe), length, dir, color, LogisticsTileRenderController.this.pipe).setReverse(reverse);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)this.entity);
        }

        @Override
        boolean isDeadEntity() {
            return this.entity == null || !this.entity.func_187113_k();
        }

        @Override
        void setDead() {
            if (this.entity != null) {
                this.entity.func_187112_i();
            }
        }

        @Override
        boolean sendPacket() {
            return false;
        }

        @Override
        void tick() {
        }

        public PipeFXLaserPowerBeam getEntity() {
            return this.entity;
        }
    }

    private static class LaserBeamData {
        final float length;
        int timeout;
        final boolean reverse;

        boolean isDeadEntity() {
            return false;
        }

        void setDead() {
        }

        boolean sendPacket() {
            return true;
        }

        void tick() {
            --this.timeout;
        }

        public float getLength() {
            return this.length;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public LaserBeamData setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LaserBeamData)) {
                return false;
            }
            LaserBeamData other = (LaserBeamData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getLength(), other.getLength()) != 0) {
                return false;
            }
            if (this.getTimeout() != other.getTimeout()) {
                return false;
            }
            return this.isReverse() == other.isReverse();
        }

        protected boolean canEqual(Object other) {
            return other instanceof LaserBeamData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getLength());
            result = result * 59 + this.getTimeout();
            result = result * 59 + (this.isReverse() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "LogisticsTileRenderController.LaserBeamData(length=" + this.getLength() + ", timeout=" + this.getTimeout() + ", reverse=" + this.isReverse() + ")";
        }

        @ConstructorProperties(value={"length", "timeout", "reverse"})
        public LaserBeamData(float length, int timeout, boolean reverse) {
            this.length = length;
            this.timeout = timeout;
            this.reverse = reverse;
        }
    }

    private static class LaserKey {
        final EnumFacing dir;
        final int color;

        public EnumFacing getDir() {
            return this.dir;
        }

        public int getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LaserKey)) {
                return false;
            }
            LaserKey other = (LaserKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EnumFacing this$dir = this.getDir();
            EnumFacing other$dir = other.getDir();
            if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
                return false;
            }
            return this.getColor() == other.getColor();
        }

        protected boolean canEqual(Object other) {
            return other instanceof LaserKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EnumFacing $dir = this.getDir();
            result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
            result = result * 59 + this.getColor();
            return result;
        }

        public String toString() {
            return "LogisticsTileRenderController.LaserKey(dir=" + this.getDir() + ", color=" + this.getColor() + ")";
        }

        @ConstructorProperties(value={"dir", "color"})
        public LaserKey(EnumFacing dir, int color) {
            this.dir = dir;
            this.color = color;
        }
    }
}

