/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import logisticspipes.LPConstants;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.IRouterQueuedTask;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class ClientRouter
implements IRouter {
    private final int _xCoord;
    private final int _yCoord;
    private final int _zCoord;

    public ClientRouter(UUID id, int dimension, int xCoord, int yCoord, int zCoord) {
        this._xCoord = xCoord;
        this._yCoord = yCoord;
        this._zCoord = zCoord;
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getSimpleID() {
        return -420;
    }

    @Override
    public void update(boolean doFullRefresh, CoreRoutedPipe pipe) {
    }

    @Override
    public boolean isRoutedExit(EnumFacing connection) {
        if (LPConstants.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return false;
    }

    @Override
    public boolean hasRoute(int id, boolean flag, ItemIdentifier item) {
        if (LPConstants.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return false;
    }

    @Override
    public ExitRoute getExitFor(int id, boolean flag, ItemIdentifier item) {
        if (LPConstants.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return null;
    }

    public ArrayList<List<ExitRoute>> getRouteTable() {
        if (LPConstants.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return new ArrayList<List<ExitRoute>>();
    }

    @Override
    public List<ExitRoute> getIRoutersByCost() {
        if (LPConstants.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return new LinkedList<ExitRoute>();
    }

    @Override
    public CoreRoutedPipe getPipe() {
        World world = MainProxy.proxy.getWorld();
        if (world == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(new BlockPos(this._xCoord, this._yCoord, this._zCoord));
        if (!(tile instanceof LogisticsTileGenericPipe)) {
            return null;
        }
        LogisticsTileGenericPipe pipe = (LogisticsTileGenericPipe)tile;
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        return (CoreRoutedPipe)pipe.pipe;
    }

    @Override
    public CoreRoutedPipe getCachedPipe() {
        return this.getPipe();
    }

    @Override
    public boolean isInDim(int dimension) {
        return true;
    }

    @Override
    public boolean isAt(int dimension, int xCoord, int yCoord, int zCoord) {
        return this._xCoord == xCoord && this._yCoord == yCoord && this._zCoord == zCoord;
    }

    @Override
    public DoubleCoordinates getLPPosition() {
        return new DoubleCoordinates(this._xCoord, this._yCoord, this._zCoord);
    }

    @Override
    public UUID getId() {
        return UUID.randomUUID();
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe == null) {
            return null;
        }
        return pipe.getLogisticsModule();
    }

    @Override
    public void clearPipeCache() {
    }

    @Override
    public List<Pair<ILogisticsPowerProvider, List<IFilter>>> getPowerProvider() {
        return null;
    }

    @Override
    public void act(BitSet hasBeenProcessed, IRouter.IRAction actor) {
    }

    @Override
    public void flagForRoutingUpdate() {
    }

    @Override
    public boolean checkAdjacentUpdate() {
        return false;
    }

    @Override
    public boolean isSideDisconnected(EnumFacing dir) {
        return false;
    }

    @Override
    public void updateInterests() {
    }

    @Override
    public List<ExitRoute> getDistanceTo(IRouter r) {
        return null;
    }

    @Override
    public void clearInterests() {
    }

    @Override
    public boolean isValidCache() {
        return true;
    }

    @Override
    public void forceLsaUpdate() {
    }

    @Override
    public boolean isSubPoweredExit(EnumFacing connection) {
        return false;
    }

    @Override
    public List<Pair<ISubSystemPowerProvider, List<IFilter>>> getSubSystemPowerProvider() {
        return null;
    }

    public String toString() {
        return String.format("ServerRouter: {UUID: %s, AT: (%d, %d, %d)}", this.getId(), this._xCoord, this._yCoord, this._zCoord);
    }

    @Override
    public List<ExitRoute> getRoutersOnSide(EnumFacing exitOrientation) {
        return null;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public int getDistanceToNextPowerPipe(EnumFacing dir) {
        return 0;
    }

    @Override
    public void queueTask(int i, IRouterQueuedTask callable) {
    }
}

