/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.interfaces.ISecurityStationManager;
import logisticspipes.interfaces.routing.IChannelConnectionManager;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.SecurityStationAuthorizedList;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ClientRouter;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.IRouterManager;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.channels.ChannelConnection;
import net.minecraft.entity.player.EntityPlayer;

public class RouterManager
implements IRouterManager,
IChannelConnectionManager,
ISecurityStationManager {
    private final ArrayList<IRouter> _routersClient = new ArrayList();
    private final ArrayList<IRouter> _routersServer = new ArrayList();
    private final Map<UUID, Integer> _uuidMap = new HashMap<UUID, Integer>();
    private final WeakHashMap<LogisticsSecurityTileEntity, Void> _security = new WeakHashMap();
    private List<String> _authorized = new LinkedList<String>();
    private final ArrayList<ChannelConnection> channelConnectedPipes = new ArrayList();

    @Override
    public IRouter getRouter(int id) {
        if (id <= 0 || MainProxy.isClient()) {
            return null;
        }
        return this._routersServer.get(id);
    }

    @Override
    public IRouter getRouterUnsafe(Integer id, boolean side) {
        if (side || id <= 0) {
            return null;
        }
        return this._routersServer.get(id);
    }

    @Override
    public int getIDforUUID(UUID id) {
        if (id == null) {
            return -1;
        }
        Integer iId = this._uuidMap.get(id);
        if (iId == null) {
            return -1;
        }
        return iId;
    }

    @Override
    public void removeRouter(int id) {
        if (!MainProxy.isClient()) {
            this._routersServer.set(id, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRouter getOrCreateRouter(UUID UUid, int dimension, int xCoord, int yCoord, int zCoord, boolean forceCreateDuplicate) {
        IRouter r = null;
        int id = this.getIDforUUID(UUid);
        if (id > 0) {
            this.getRouter(id);
        }
        if (r == null || !r.isAt(dimension, xCoord, yCoord, zCoord)) {
            if (MainProxy.isClient()) {
                ArrayList<IRouter> arrayList = this._routersClient;
                synchronized (arrayList) {
                    for (IRouter r2 : this._routersClient) {
                        if (!r2.isAt(dimension, xCoord, yCoord, zCoord)) continue;
                        return r2;
                    }
                    r = new ClientRouter(UUid, dimension, xCoord, yCoord, zCoord);
                    this._routersClient.add(r);
                }
            }
            ArrayList<IRouter> arrayList = this._routersServer;
            synchronized (arrayList) {
                if (!forceCreateDuplicate) {
                    for (IRouter r2 : this._routersServer) {
                        if (r2 == null || !r2.isAt(dimension, xCoord, yCoord, zCoord)) continue;
                        return r2;
                    }
                }
                r = new ServerRouter(UUid, dimension, xCoord, yCoord, zCoord);
                int rId = r.getSimpleID();
                if (this._routersServer.size() > rId) {
                    this._routersServer.set(rId, r);
                } else {
                    this._routersServer.ensureCapacity(rId + 1);
                    while (this._routersServer.size() <= rId) {
                        this._routersServer.add(null);
                    }
                    this._routersServer.set(rId, r);
                }
                this._uuidMap.put(r.getId(), r.getSimpleID());
            }
        }
        return r;
    }

    @Override
    public boolean isRouter(int id) {
        if (MainProxy.isClient()) {
            return true;
        }
        return this._routersServer.get(id) != null;
    }

    @Override
    public boolean isRouterUnsafe(int id, boolean side) {
        if (side) {
            return true;
        }
        return this._routersServer.get(id) != null;
    }

    @Override
    public List<IRouter> getRouters() {
        if (MainProxy.isClient()) {
            return Collections.unmodifiableList(this._routersClient);
        }
        return Collections.unmodifiableList(this._routersServer);
    }

    @Override
    public boolean hasChannelConnection(IRouter router) {
        return this.channelConnectedPipes.stream().filter(con -> con.routers.size() > 1).anyMatch(con -> con.routers.contains(router.getSimpleID()));
    }

    @Override
    public boolean addChannelConnection(UUID ident, IRouter router) {
        if (MainProxy.isClient()) {
            return false;
        }
        int routerSimpleID = router.getSimpleID();
        this.channelConnectedPipes.forEach(con -> con.routers.remove(routerSimpleID));
        Optional<ChannelConnection> channel = this.channelConnectedPipes.stream().filter(con -> con.identifier.equals(ident)).findFirst();
        if (channel.isPresent()) {
            channel.get().routers.add(routerSimpleID);
        } else {
            ChannelConnection newChannel = new ChannelConnection();
            this.channelConnectedPipes.add(newChannel);
            newChannel.identifier = ident;
            newChannel.routers.add(routerSimpleID);
        }
        return true;
    }

    @Override
    public List<CoreRoutedPipe> getConnectedPipes(IRouter router) {
        Optional<ChannelConnection> channel = this.channelConnectedPipes.stream().filter(con -> con.routers.contains(router.getSimpleID())).findFirst();
        return channel.map(channelConnection -> channelConnection.routers.stream().filter(r -> r.intValue() != router.getSimpleID()).map(r -> this.getRouter((int)r).getPipe()).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public void removeChannelConnection(IRouter router) {
        if (MainProxy.isClient()) {
            return;
        }
        Optional<ChannelConnection> channel = this.channelConnectedPipes.stream().filter(con -> con.routers.contains(router.getSimpleID())).findFirst();
        channel.ifPresent(chan -> chan.routers.remove(router.getSimpleID()));
        if (channel.filter(chan -> chan.routers.isEmpty()).isPresent()) {
            this.channelConnectedPipes.remove(channel.get());
        }
    }

    @Override
    public void serverStopClean() {
        this.channelConnectedPipes.clear();
        this._routersServer.clear();
        this._uuidMap.clear();
        this._security.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearClientRouters() {
        ArrayList<IRouter> arrayList = this._routersClient;
        synchronized (arrayList) {
            this._routersClient.clear();
        }
    }

    @Override
    public void add(LogisticsSecurityTileEntity tile) {
        this._security.put(tile, null);
        this.authorizeUUID(tile.getSecId());
    }

    @Override
    public LogisticsSecurityTileEntity getStation(UUID id) {
        if (id == null) {
            return null;
        }
        for (LogisticsSecurityTileEntity tile : this._security.keySet()) {
            if (!id.equals(tile.getSecId())) continue;
            return tile;
        }
        return null;
    }

    @Override
    public void remove(LogisticsSecurityTileEntity tile) {
        this._security.remove(tile);
        this.deauthorizeUUID(tile.getSecId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dimensionUnloaded(int dim) {
        ArrayList<IRouter> arrayList = this._routersServer;
        synchronized (arrayList) {
            this._routersServer.stream().filter(r -> r != null && r.isInDim(dim)).forEach(r -> {
                r.clearPipeCache();
                r.clearInterests();
            });
        }
    }

    @Override
    public void deauthorizeUUID(UUID id) {
        this._authorized.remove(id.toString());
        this.sendClientAuthorizationList();
    }

    @Override
    public void authorizeUUID(UUID id) {
        if (!this._authorized.contains(id.toString())) {
            this._authorized.add(id.toString());
        }
        this.sendClientAuthorizationList();
    }

    @Override
    public boolean isAuthorized(UUID id) {
        if (this._authorized.isEmpty() || id == null) {
            return false;
        }
        return this._authorized.contains(id.toString());
    }

    @Override
    public boolean isAuthorized(String id) {
        if (this._authorized.isEmpty() || id == null) {
            return false;
        }
        return this._authorized.contains(id);
    }

    @Override
    public void setClientAuthorizationList(List<String> list) {
        this._authorized = list;
    }

    @Override
    public void sendClientAuthorizationList() {
        MainProxy.sendToAllPlayers(PacketHandler.getPacket(SecurityStationAuthorizedList.class).setStringList(this._authorized));
    }

    @Override
    public void sendClientAuthorizationList(EntityPlayer player) {
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SecurityStationAuthorizedList.class).setStringList(this._authorized), player);
    }

    @Override
    public void printAllRouters() {
        this._routersServer.stream().filter(router -> router != null).forEach(router -> System.out.println(router.toString()));
    }
}

