/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.order.IDistanceTracker;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.item.ItemIdentifier;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public abstract class LogisticsOrder
implements IOrderInfoProvider {
    private static final int MIN_DISTANCE_TO_DISPLAY = 4;
    private final IAdditionalTargetInformation information;
    private boolean isFinished = false;
    private final IOrderInfoProvider.ResourceType type;
    private boolean inProgress;
    private boolean isWatched = false;
    private byte machineProgress = 0;
    private List<IDistanceTracker> trackers = new ArrayList<IDistanceTracker>();

    public LogisticsOrder(IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.information = info;
    }

    @Override
    public int getRouterId() {
        if (this.getRouter() == null) {
            return -1;
        }
        return this.getRouter().getSimpleID();
    }

    public abstract IRouter getRouter();

    @Override
    public void setWatched() {
        this.isWatched = true;
    }

    public void addDistanceTracker(IDistanceTracker tracker) {
        this.trackers.add(tracker);
    }

    @Override
    public List<Float> getProgresses() {
        ArrayList<Float> progresses = new ArrayList<Float>();
        for (IDistanceTracker tracker : this.trackers) {
            float f;
            if (tracker.hasReachedDestination() || tracker.isTimeout() || progresses.contains(Float.valueOf(f = tracker.getInitialDistanceToTarget() != 0 ? (float)tracker.getCurrentDistanceToTarget() / (float)tracker.getInitialDistanceToTarget() : 1.0f)) || tracker.getInitialDistanceToTarget() <= 4 && tracker.getInitialDistanceToTarget() != 0) continue;
            progresses.add(Float.valueOf(f));
        }
        return progresses;
    }

    public abstract void sendFailed();

    public abstract int getAmount();

    public abstract void reduceAmountBy(int var1);

    @Override
    public ItemIdentifier getTargetType() {
        if (this.getRouter() == null || this.getRouter().getPipe() == null) {
            return null;
        }
        return ItemIdentifier.get(this.getRouter().getPipe().item, 0, null);
    }

    @Override
    public DoubleCoordinates getTargetPosition() {
        if (this.getRouter() == null) {
            return null;
        }
        return this.getRouter().getLPPosition();
    }

    public IAdditionalTargetInformation getInformation() {
        return this.information;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    public LogisticsOrder setFinished(boolean isFinished) {
        this.isFinished = isFinished;
        return this;
    }

    @Override
    public IOrderInfoProvider.ResourceType getType() {
        return this.type;
    }

    @Override
    public boolean isInProgress() {
        return this.inProgress;
    }

    public LogisticsOrder setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
        return this;
    }

    @Override
    public boolean isWatched() {
        return this.isWatched;
    }

    @Override
    public byte getMachineProgress() {
        return this.machineProgress;
    }

    public LogisticsOrder setMachineProgress(byte machineProgress) {
        this.machineProgress = machineProgress;
        return this;
    }
}

