/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import java.util.Collections;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IGuiAccess;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.text.TextFormatting;

public class TextListDisplay {
    private final List list;
    private final IGuiAccess gui;
    private final int borderTop;
    private final int borderRight;
    private final int borderBottom;
    private final int borderLeft;
    private final int elementPerPage;
    private int mouseClickX = 0;
    private int mouseClickY = 0;
    private int mousePosX = 0;
    private int mousePosY = 0;
    private int scroll = 0;
    private int selected = -1;
    private int hover = -1;

    public TextListDisplay(IGuiAccess gui, int borderLeft, int borderTop, int borderRight, int borderBottom, int elementPerPage, List list) {
        this.list = list;
        this.gui = gui;
        this.borderTop = borderTop;
        this.borderRight = borderRight;
        this.borderBottom = borderBottom;
        this.borderLeft = borderLeft;
        this.elementPerPage = elementPerPage;
    }

    public void mouseClicked(int i, int j, int k) {
        this.mouseClickX = i;
        this.mouseClickY = j;
    }

    public void renderGuiBackground(int mouseX, int mouseY) {
        this.mousePosX = mouseX;
        this.mousePosY = mouseY;
        Gui.func_73734_a((int)(this.gui.getGuiLeft() + this.borderLeft), (int)(this.gui.getGuiTop() + this.borderTop), (int)(this.gui.getRight() - this.borderRight), (int)(this.gui.getBottom() - this.borderBottom), (int)Color.getValue(Color.GREY));
        if (this.scroll + this.elementPerPage > this.list.getSize()) {
            this.scroll = this.list.getSize() - this.elementPerPage;
        }
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        boolean flag = false;
        this.hover = -1;
        if (this.gui.getGuiLeft() + this.borderLeft + 2 < this.mousePosX && this.mousePosX < this.gui.getRight() - this.borderRight - 2 && this.gui.getGuiTop() + this.borderTop + 2 < this.mousePosY && this.mousePosY < this.gui.getGuiTop() + this.borderTop + 3 + this.elementPerPage * 10) {
            this.hover = this.scroll + (this.mousePosY - this.gui.getGuiTop() - this.borderTop - 3) / 10;
        }
        if (this.list.getSize() == 0 || this.hover >= this.list.getSize()) {
            this.hover = -1;
        }
        if (this.gui.getGuiLeft() + this.borderLeft + 2 < this.mouseClickX && this.mouseClickX < this.gui.getRight() - this.borderRight - 2 && this.gui.getGuiTop() + this.borderTop + 2 < this.mouseClickY && this.mouseClickY < this.gui.getGuiTop() + this.borderTop + 3 + this.elementPerPage * 10) {
            this.selected = this.scroll + (this.mouseClickY - this.gui.getGuiTop() - this.borderTop - 3) / 10;
            this.mouseClickX = -1;
            this.mouseClickY = -1;
        }
        for (int i = this.scroll; i < this.list.getSize() && i - this.scroll < this.elementPerPage; ++i) {
            if (i == this.selected) {
                Gui.func_73734_a((int)(this.gui.getGuiLeft() + this.borderLeft + 2), (int)(this.gui.getGuiTop() + this.borderTop + 2 + (i - this.scroll) * 10), (int)(this.gui.getRight() - this.borderRight - 2), (int)(this.gui.getGuiTop() + this.borderTop + 13 + (i - this.scroll) * 10), (int)Color.getValue(Color.DARKER_GREY));
                flag = true;
            }
            String name = this.list.getTextAt(i);
            name = StringUtils.getCuttedString(name, this.gui.getXSize() - this.borderRight - this.borderLeft - 6, this.gui.getMC().field_71466_p);
            this.gui.getMC().field_71466_p.func_78276_b(name, this.gui.getGuiLeft() + this.borderLeft + 4, this.gui.getGuiTop() + this.borderTop + 4 + (i - this.scroll) * 10, this.list.getTextColor(i));
        }
        if (!flag) {
            this.selected = -1;
        }
    }

    public void renderGuiForeground() {
        if (this.hover != -1) {
            GuiGraphics.drawToolTip(this.mousePosX - this.gui.getGuiLeft(), this.mousePosY - this.gui.getGuiTop(), Collections.singletonList(this.list.getTextAt(this.hover)), TextFormatting.WHITE);
        }
    }

    public void scrollUp() {
        ++this.scroll;
    }

    public void scrollDown() {
        if (this.scroll > 0) {
            --this.scroll;
        }
    }

    public void mouseScrollUp() {
        if (this.gui.getGuiLeft() + this.borderLeft < this.mousePosX && this.mousePosX < this.gui.getRight() - this.borderRight && this.gui.getGuiTop() + this.borderTop < this.mousePosY && this.mousePosY < this.gui.getBottom() + this.borderBottom) {
            this.scrollUp();
        }
    }

    public void mouseScrollDown() {
        if (this.gui.getGuiLeft() + this.borderLeft < this.mousePosX && this.mousePosX < this.gui.getRight() - this.borderRight && this.gui.getGuiTop() + this.borderTop < this.mousePosY && this.mousePosY < this.gui.getBottom() + this.borderBottom) {
            this.scrollDown();
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public TextListDisplay setSelected(int selected) {
        this.selected = selected;
        return this;
    }

    public static interface List {
        public int getSize();

        public String getTextAt(int var1);

        public int getTextColor(int var1);
    }
}

