/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui.extention;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.extention.GuiExtention;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Slot;

public class GuiExtentionController {
    private final List<GuiExtention> extentions = new ArrayList<GuiExtention>();
    private final List<GuiExtention> extentionsToRemove = new ArrayList<GuiExtention>();
    private int maxBottom;
    private GuiExtention currentlyExtended = null;
    private Map<Slot, Integer> slotMap = new HashMap<Slot, Integer>();
    private Map<GuiButton, Integer> buttonMap = new HashMap<GuiButton, Integer>();
    private final GuiSide side;

    public GuiExtentionController(GuiSide side) {
        this.side = side;
    }

    public void render(int xPos, int yPos) {
        yPos += 4;
        if (this.currentlyExtended == null) {
            for (GuiExtention extention : this.extentions) {
                int right;
                int left;
                extention.setExtending(false);
                if (this.side == GuiSide.LEFT) {
                    left = xPos - extention.getCurrentWidth();
                    right = xPos + 15;
                } else {
                    left = xPos - 15;
                    right = xPos + extention.getCurrentWidth();
                }
                int bottom = yPos + extention.getCurrentHeight();
                extention.update(left, yPos);
                GuiGraphics.drawGuiBackGround(Minecraft.func_71410_x(), left, yPos, right, bottom, 0.0f, true, true, this.side != GuiSide.RIGHT, true, this.side != GuiSide.LEFT);
                extention.renderForground(left + (this.side == GuiSide.RIGHT ? 20 : 0), yPos);
                yPos = bottom;
            }
        } else if (this.currentlyExtended.isExtending()) {
            int right;
            int left;
            if (this.side == GuiSide.LEFT) {
                left = xPos - this.currentlyExtended.getCurrentWidth();
                right = xPos + 15;
            } else {
                left = xPos - 15;
                right = xPos + this.currentlyExtended.getCurrentWidth();
            }
            int bottom = this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight();
            this.currentlyExtended.update(left, yPos);
            GuiGraphics.drawGuiBackGround(Minecraft.func_71410_x(), left, this.currentlyExtended.getCurrentYPos(), right, bottom, 0.0f, true, true, this.side != GuiSide.RIGHT, true, this.side != GuiSide.LEFT);
            this.currentlyExtended.renderForground(left + (this.side == GuiSide.RIGHT ? 20 : 0), this.currentlyExtended.getCurrentYPos());
        } else {
            int right;
            int left;
            int bottom;
            for (GuiExtention extention : this.extentions) {
                if (extention == this.currentlyExtended) break;
                extention.setExtending(false);
                yPos = bottom = yPos + extention.getCurrentHeight();
            }
            if (this.side == GuiSide.LEFT) {
                left = xPos - this.currentlyExtended.getCurrentWidth();
                right = xPos + 15;
            } else {
                left = xPos - 15;
                right = xPos + this.currentlyExtended.getCurrentWidth();
            }
            bottom = this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight();
            this.currentlyExtended.update(left, yPos);
            GuiGraphics.drawGuiBackGround(Minecraft.func_71410_x(), left, this.currentlyExtended.getCurrentYPos(), right, bottom, 0.0f, true, true, this.side != GuiSide.RIGHT, true, this.side != GuiSide.LEFT);
            this.currentlyExtended.renderForground(left + (this.side == GuiSide.RIGHT ? 20 : 0), this.currentlyExtended.getCurrentYPos());
            if (this.currentlyExtended.isFullyRetracted()) {
                this.currentlyExtended = null;
            }
        }
        if (this.currentlyExtended != null && this.extentionsToRemove.contains(this.currentlyExtended)) {
            this.currentlyExtended = null;
        }
        this.extentions.removeAll(this.extentionsToRemove);
        this.extentionsToRemove.clear();
    }

    public void addExtention(GuiExtention extention) {
        this.extentions.add(extention);
    }

    public void removeExtention(GuiExtention extention) {
        this.extentionsToRemove.add(extention);
    }

    public void mouseClicked(int x, int y, int k) {
        if (this.currentlyExtended == null) {
            this.extentions.stream().filter(extention -> x > extention.getCurrentXPos() && x < extention.getCurrentXPos() + extention.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) && y > extention.getCurrentYPos() && y < extention.getCurrentYPos() + extention.getCurrentHeight()).forEach(extention -> {
                this.currentlyExtended = extention;
                this.currentlyExtended.setExtending(true);
            });
        } else if (x > this.currentlyExtended.getCurrentXPos() && x < this.currentlyExtended.getCurrentXPos() + this.currentlyExtended.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) && y > this.currentlyExtended.getCurrentYPos() && y < this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight()) {
            this.currentlyExtended.setExtending(false);
        }
    }

    public void mouseOver(int i, int j) {
        int x = i;
        int y = j;
        if (this.currentlyExtended == null) {
            for (GuiExtention extention : this.extentions) {
                if (x <= extention.getCurrentXPos() || x >= extention.getCurrentXPos() + extention.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) || y <= extention.getCurrentYPos() || y >= extention.getCurrentYPos() + extention.getCurrentHeight()) continue;
                extention.handleMouseOverAt(x, y);
                return;
            }
        } else if (x > this.currentlyExtended.getCurrentXPos() && x < this.currentlyExtended.getCurrentXPos() + this.currentlyExtended.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) && y > this.currentlyExtended.getCurrentYPos() && y < this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight()) {
            this.currentlyExtended.handleMouseOverAt(x, y);
            return;
        }
    }

    public int registerControlledSlot(Slot slot) {
        int size = this.slotMap.size();
        this.slotMap.put(slot, size);
        return size;
    }

    public boolean renderSlot(Slot slot) {
        if (!this.slotMap.containsKey(slot)) {
            return true;
        }
        if (this.currentlyExtended == null) {
            return false;
        }
        if (!this.currentlyExtended.isFullyExtended()) {
            return false;
        }
        int id = this.slotMap.get(slot);
        return this.currentlyExtended.renderSlot(id);
    }

    public boolean renderSelectSlot(Slot slot) {
        if (!this.slotMap.containsKey(slot)) {
            return true;
        }
        if (this.currentlyExtended == null) {
            return false;
        }
        if (!this.currentlyExtended.isFullyExtended()) {
            return false;
        }
        int id = this.slotMap.get(slot);
        return this.currentlyExtended.renderSelectSlot(id);
    }

    public int registerControlledButton(GuiButton button) {
        int size = this.buttonMap.size();
        this.buttonMap.put(button, size);
        return size;
    }

    public boolean renderButtonControlled(GuiButton button) {
        return this.buttonMap.containsKey(button);
    }

    public boolean renderButton(GuiButton button) {
        if (!this.buttonMap.containsKey(button)) {
            return true;
        }
        if (this.currentlyExtended == null) {
            return false;
        }
        if (!this.currentlyExtended.isFullyExtended()) {
            return false;
        }
        int id = this.buttonMap.get(button);
        return this.currentlyExtended.renderButton(id);
    }

    public void clear() {
        this.extentions.clear();
        this.extentionsToRemove.clear();
        this.currentlyExtended = null;
    }

    public void retract() {
        if (this.currentlyExtended != null) {
            this.currentlyExtended.setExtending(false);
        }
    }

    public boolean isOverPanel(int x, int y, int w, int h) {
        if (this.currentlyExtended == null) {
            for (GuiExtention extention : this.extentions) {
                if (x + w <= extention.getCurrentXPos() || x >= extention.getCurrentXPos() + extention.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) || y + h <= extention.getCurrentYPos() || y >= extention.getCurrentYPos() + extention.getCurrentHeight()) continue;
                return true;
            }
        } else if (x + w > this.currentlyExtended.getCurrentXPos() && x < this.currentlyExtended.getCurrentXPos() + this.currentlyExtended.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) && y + h > this.currentlyExtended.getCurrentYPos() && y < this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight()) {
            return true;
        }
        return false;
    }

    public GuiExtentionController setMaxBottom(int maxBottom) {
        this.maxBottom = maxBottom;
        return this;
    }

    public static enum GuiSide {
        LEFT,
        RIGHT;

    }
}

