/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import logisticspipes.LogisticsPipes;
import logisticspipes.utils.PlayerIdentifier;
import net.minecraftforge.fml.common.FMLCommonHandler;
import network.rs485.logisticspipes.config.ClientConfiguration;
import network.rs485.logisticspipes.config.PlayerConfiguration;
import network.rs485.logisticspipes.config.ServerConfiguration;
import network.rs485.logisticspipes.config.ServerConfigurationManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0012\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u0006H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fJ\b\u0010\u0018\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnetwork/rs485/logisticspipes/config/ServerConfigurationManager;", "", "()V", "configFile", "Ljava/io/File;", "fileName", "", "gson", "Lcom/google/gson/Gson;", "internalRepresentation", "Lnetwork/rs485/logisticspipes/config/ServerConfiguration;", "getPlayerConfiguration", "Lnetwork/rs485/logisticspipes/config/PlayerConfiguration;", "identifier", "Llogisticspipes/utils/PlayerIdentifier;", "getPlayers", "", "getTimedFile", "suffix", "setClientConfiguration", "", "configuration", "Lnetwork/rs485/logisticspipes/config/ClientConfiguration;", "setPlayerConfiguration", "writeChange", "logisticspipes"})
public final class ServerConfigurationManager {
    private final String fileName = "logisticspipes.json";
    private final File configFile;
    private final Gson gson = new Gson();
    private final ServerConfiguration internalRepresentation;

    @NotNull
    public final Set<PlayerIdentifier> getPlayers() {
        return this.internalRepresentation.getPlayerConfigurations().keySet();
    }

    @NotNull
    public final PlayerConfiguration getPlayerConfiguration(@NotNull PlayerIdentifier identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        PlayerConfiguration playerConfiguration = this.internalRepresentation.getPlayerConfigurations().get(identifier);
        if (playerConfiguration == null) {
            playerConfiguration = new PlayerConfiguration();
        }
        return playerConfiguration;
    }

    public final void setClientConfiguration(@NotNull PlayerIdentifier identifier, @NotNull ClientConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Map newConfigurations = MapsKt.toMutableMap(this.internalRepresentation.getPlayerConfigurations());
        ((PlayerConfiguration)newConfigurations.computeIfAbsent(identifier, setClientConfiguration.1.INSTANCE)).merge(configuration);
        this.internalRepresentation.setPlayerConfigurations(newConfigurations);
        this.writeChange();
    }

    public final void setPlayerConfiguration(@NotNull PlayerIdentifier identifier, @NotNull PlayerConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        HashMap<PlayerIdentifier, PlayerConfiguration> newConfigurations = new HashMap<PlayerIdentifier, PlayerConfiguration>(this.internalRepresentation.getPlayerConfigurations());
        ((Map)newConfigurations).put(identifier, configuration);
        this.internalRepresentation.setPlayerConfigurations((Map<PlayerIdentifier, PlayerConfiguration>)newConfigurations);
        this.writeChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeChange() {
        File tmpFile = this.getTimedFile(".tmp");
        try {
            Object object = tmpFile;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileOutputStream((File)object3);
            bl3 = false;
            object2 = new OutputStreamWriter((OutputStream)object3, charset);
            bl2 = false;
            object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)object;
                boolean bl5 = false;
                JsonElement jsonElement = this.gson.toJsonTree((Object)this.internalRepresentation, (Type)((Object)ServerConfiguration.class));
                this.gson.toJson(jsonElement, this.gson.newJsonWriter((Writer)it));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Files.move(tmpFile.toPath(), this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpFile.toPath());
        }
    }

    private final File getTimedFile(String suffix) {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        String time = String.valueOf(calendar.getTimeInMillis());
        return new File(this.configFile.getParentFile(), this.configFile.getName() + '.' + time + suffix);
    }

    static /* synthetic */ File getTimedFile$default(ServerConfigurationManager serverConfigurationManager, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return serverConfigurationManager.getTimedFile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConfigurationManager() {
        ServerConfigurationManager serverConfigurationManager;
        Object object;
        FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
        this.configFile = new File(fMLCommonHandler.getSavesDirectory(), this.fileName);
        ServerConfigurationManager serverConfigurationManager2 = this;
        try {
            ServerConfiguration serverConfiguration;
            object = this.configFile;
            Charset charset = Charsets.UTF_8;
            ServerConfigurationManager serverConfigurationManager3 = serverConfigurationManager2;
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileInputStream((File)object3);
            bl3 = false;
            object2 = new InputStreamReader((InputStream)object3, charset);
            bl2 = false;
            Object object4 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            object = (Closeable)object4;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl5 = false;
                Object object5 = this.gson.fromJson(this.gson.newJsonReader((Reader)it), (Type)((Object)ServerConfiguration.class));
                Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"gson.fromJson(gson.newJs\u2026onfiguration::class.java)");
                serverConfiguration = (ServerConfiguration)object5;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object4 = serverConfiguration;
            serverConfigurationManager = serverConfigurationManager3;
            Object object6 = object4;
            Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"configFile.bufferedReade\u2026class.java)\n            }");
            object = object6;
        }
        catch (JsonParseException jsonParseException) {
            serverConfigurationManager = serverConfigurationManager2;
            LogisticsPipes.log.error("Cannot read LP configuration! Moving current configuration away and starting a new one!");
            Files.move(this.configFile.toPath(), this.getTimedFile(".bkp").toPath(), new CopyOption[0]);
            object = new ServerConfiguration();
        }
        catch (FileNotFoundException e) {
            serverConfigurationManager = serverConfigurationManager2;
            LogisticsPipes.log.info("Starting a new LP configuration");
            object = new ServerConfiguration();
        }
        serverConfigurationManager.internalRepresentation = object;
    }
}

