/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.proxy.mcmp;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import logisticspipes.LPBlocks;
import logisticspipes.asm.mcmp.MCMPHooks;
import logisticspipes.modplugins.mcmp.LPPipeMultipart;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import mcmultipart.MCMultiPart;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.event.DrawMultipartHighlightEvent;
import mcmultipart.api.multipart.MultipartOcclusionHelper;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.client.ModelMultipartContainer;
import mcmultipart.multipart.PartInfo;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.proxy.mcmp.IMCMPProxy;
import network.rs485.logisticspipes.proxy.mcmp.subproxy.IMCMPBlockAccess;
import network.rs485.logisticspipes.proxy.mcmp.subproxy.IMCMPLTGPCompanion;
import network.rs485.logisticspipes.proxy.mcmp.subproxy.LPTileMultipartContainer;
import network.rs485.logisticspipes.proxy.mcmp.subproxy.MCMPBlockAccess;
import network.rs485.logisticspipes.proxy.mcmp.subproxy.MCMPLTGPCompanion;

public class MCMPProxy
implements IMCMPProxy {
    @SideOnly(value=Side.CLIENT)
    private ModelMultipartContainer modelMultipartContainer;

    public MCMPProxy() {
        MCMPHooks.mcmpGetTEHook = (world, pos) -> {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof LogisticsTileGenericPipe) {
                LogisticsTileGenericPipe lpTile = (LogisticsTileGenericPipe)tile;
                TileEntity nTile = lpTile.imcmpltgpCompanion.getMCMPTileEntity();
                if (nTile != null) {
                    return nTile;
                }
            }
            return tile;
        };
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public IMCMPLTGPCompanion createMCMPCompanionFor(LogisticsTileGenericPipe pipe) {
        return new MCMPLTGPCompanion(pipe);
    }

    @Override
    public IMCMPBlockAccess createMCMPBlockAccess() {
        return new MCMPBlockAccess();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> addQuads(List<BakedQuad> list, IBlockState state, EnumFacing side, long rand) {
        List newQuads;
        if (this.modelMultipartContainer == null) {
            this.modelMultipartContainer = new ModelMultipartContainer();
        }
        if ((newQuads = this.modelMultipartContainer.func_188616_a(state, side, rand)).isEmpty()) {
            return list;
        }
        return Stream.concat(list.stream(), this.modelMultipartContainer.func_188616_a(state, side, rand).stream()).collect(Collectors.toList());
    }

    @Override
    public void registerTileEntities() {
        GameRegistry.registerTileEntity(LPTileMultipartContainer.class, (ResourceLocation)new ResourceLocation("logisticspipes", "mcmp_lp_tile_multipart_container"));
    }

    @Override
    public boolean checkIntersectionWith(LogisticsTileGenericPipe logisticsTileGenericPipe, AxisAlignedBB aabb) {
        return ((TileMultipartContainer)logisticsTileGenericPipe.imcmpltgpCompanion.getMCMPTileEntity()).getParts().values().stream().filter(i -> !(i.getPart() instanceof LPPipeMultipart)).anyMatch(i -> MultipartOcclusionHelper.testBoxIntersection((Collection)i.getPart().getOcclusionBoxes((IPartInfo)i), Collections.singletonList(aabb)));
    }

    @Override
    public boolean hasParts(LogisticsTileGenericPipe pipeTile) {
        return ((TileMultipartContainer)pipeTile.imcmpltgpCompanion.getMCMPTileEntity()).getParts().values().stream().anyMatch(i -> !(i.getPart() instanceof LPPipeMultipart));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTileEntitySpecialRenderer(LogisticsTileGenericPipe tileentity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileEntitySpecialRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147546_a(TileMultipartContainer.class);
        if (destroyStage < 0 || tileentity.imcmpltgpCompanion.getMCMPTileEntity() != null && Minecraft.func_71410_x().field_71476_x != null) {
            renderer.func_192841_a(tileentity.imcmpltgpCompanion.getMCMPTileEntity(), x, y, z, partialTicks, destroyStage, alpha);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDrawHighlight(DrawBlockHighlightEvent event) {
        if (event instanceof DrawMultipartHighlightEvent) {
            return;
        }
        RayTraceResult hit = event.getTarget();
        if (hit.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = hit.func_178782_a();
        EntityPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        if (world.func_180495_p(pos).func_177230_c() == LPBlocks.pipe) {
            Optional tile = BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos);
            if (!tile.isPresent()) {
                return;
            }
            int slotID = hit.subHit;
            if (slotID < 0) {
                return;
            }
            PartInfo info = (PartInfo)((TileMultipartContainer)tile.get()).getParts().get(MCMultiPart.slotRegistry.getValue(slotID));
            if (info == null || !(hit.hitInfo instanceof RayTraceResult)) {
                return;
            }
            hit = (RayTraceResult)hit.hitInfo;
            float partialTicks = event.getPartialTicks();
            if (!MinecraftForge.EVENT_BUS.post((Event)new DrawMultipartHighlightEvent(event.getContext(), player, hit, slotID, partialTicks, (IPartInfo)info))) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187441_d((float)2.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                IBlockState state = info.getState();
                if (state.func_185904_a() != Material.field_151579_a && world.func_175723_af().func_177746_a(pos)) {
                    double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                    double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                    double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                    RenderGlobal.func_189697_a((AxisAlignedBB)info.getPart().getSelectedBoundingBox((IPartInfo)info).func_186662_g(0.002).func_72317_d(-x, -y, -z), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (tile instanceof LogisticsTileGenericPipe) {
            ((LogisticsTileGenericPipe)tile).scheduleNeighborChange();
        }
    }
}

