/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.world;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.IntegerCoordinates;

public class WorldCoordinatesWrapper {
    private World world;
    private IntegerCoordinates coords;

    public WorldCoordinatesWrapper(World world) {
        this.setWorld(world);
        this.setCoords(new IntegerCoordinates());
    }

    public WorldCoordinatesWrapper(World world, IntegerCoordinates coords) {
        this.setWorld(world);
        this.setCoords(coords);
    }

    public WorldCoordinatesWrapper(World world, BlockPos coords) {
        this.setWorld(world);
        this.setCoords(new IntegerCoordinates(coords));
    }

    public WorldCoordinatesWrapper(World world, int xCoord, int yCoord, int zCoord) {
        this.setWorld(world);
        this.setCoords(new IntegerCoordinates(xCoord, yCoord, zCoord));
    }

    public WorldCoordinatesWrapper(TileEntity tileEntity) {
        this(tileEntity.func_145831_w(), tileEntity.func_174877_v());
    }

    @Nullable
    private static TileEntity getTileEntity(World world, IntegerCoordinates coords) {
        return world.func_175625_s(new BlockPos(coords.getXCoord(), coords.getYCoord(), coords.getZCoord()));
    }

    public void setWorld(World world) {
        if (world == null) {
            throw new NullPointerException("World must not be null");
        }
        this.world = world;
    }

    public void setCoords(IntegerCoordinates coords) {
        if (coords == null) {
            throw new NullPointerException("Coordinates must not be null");
        }
        this.coords = coords;
    }

    public Stream<NeighborTileEntity<TileEntity>> allNeighborTileEntities() {
        return Arrays.stream(EnumFacing.field_82609_l).map(this::getNeighbor).filter(Objects::nonNull);
    }

    public Stream<NeighborTileEntity<TileEntity>> connectedTileEntities() {
        TileEntity pipe = this.getTileEntity();
        if (SimpleServiceLocator.pipeInformationManager.isNotAPipe(pipe)) {
            LogisticsPipes.log.warn("The coordinates didn't hold a pipe at all", new Throwable("Stack trace"));
            return Stream.empty();
        }
        return this.allNeighborTileEntities().filter(adjacent -> MainProxy.checkPipesConnections(pipe, adjacent.getTileEntity(), adjacent.getDirection()));
    }

    public Stream<NeighborTileEntity<TileEntity>> connectedTileEntities(IPipeInformationProvider.ConnectionPipeType pipeType) {
        TileEntity pipe = this.getTileEntity();
        if (!SimpleServiceLocator.pipeInformationManager.isPipe(pipe, true, pipeType)) {
            if (LPConstants.DEBUG) {
                LogisticsPipes.log.warn("The coordinates didn't hold the pipe type " + (Object)((Object)pipeType), new Throwable("Stack trace"));
            }
            return Stream.empty();
        }
        return this.allNeighborTileEntities().filter(neighbor -> MainProxy.checkPipesConnections(pipe, neighbor.getTileEntity(), neighbor.getDirection()));
    }

    @Nullable
    public TileEntity getTileEntity() {
        return WorldCoordinatesWrapper.getTileEntity(this.world, this.coords);
    }

    @Nullable
    public NeighborTileEntity<TileEntity> getNeighbor(@Nonnull EnumFacing direction) {
        IntegerCoordinates newCoords = CoordinateUtils.add(new IntegerCoordinates(this.coords), direction);
        TileEntity tileEntity = WorldCoordinatesWrapper.getTileEntity(this.world, newCoords);
        if (tileEntity == null) {
            return null;
        }
        return new NeighborTileEntity<TileEntity>(tileEntity, direction);
    }

    public World getWorld() {
        return this.world;
    }

    public IntegerCoordinates getCoords() {
        return this.coords;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorldCoordinatesWrapper)) {
            return false;
        }
        WorldCoordinatesWrapper other = (WorldCoordinatesWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        IntegerCoordinates this$coords = this.getCoords();
        IntegerCoordinates other$coords = other.getCoords();
        return !(this$coords == null ? other$coords != null : !((Object)this$coords).equals(other$coords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorldCoordinatesWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        IntegerCoordinates $coords = this.getCoords();
        result = result * 59 + ($coords == null ? 43 : ((Object)$coords).hashCode());
        return result;
    }

    public String toString() {
        return "WorldCoordinatesWrapper(world=" + this.getWorld() + ", coords=" + this.getCoords() + ")";
    }
}

