/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.holograms;

import com.google.inject.Inject;
import de.randombyte.holograms.HologramsServiceImpl;
import de.randombyte.holograms.api.HologramsService;
import de.randombyte.holograms.commands.ListNearbyHologramsCommand;
import de.randombyte.holograms.commands.SetNearestHologramText;
import de.randombyte.holograms.commands.SpawnMultiLineTextHologramCommand;
import de.randombyte.holograms.commands.SpawnTextHologramCommand;
import de.randombyte.holograms.data.HologramData;
import de.randombyte.holograms.data.HologramKeys;
import de.randombyte.holograms.shaded.bstats.sponge.Metrics;
import de.randombyte.holograms.shaded.kosp.extensions.StringsKt;
import de.randombyte.holograms.shaded.kotlin.Metadata;
import de.randombyte.holograms.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import de.randombyte.holograms.shaded.kotlin.jvm.internal.Intrinsics;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;

@Plugin(id="holograms", name="Holograms", version="3.1.5", authors={"RandomByte"})
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0007J\f\u0010\u0018\u001a\u00020\u0011*\u00020\u0005H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/randombyte/holograms/Holograms;", "", "logger", "Lorg/slf4j/Logger;", "configPath", "Ljava/nio/file/Path;", "pluginContainer", "Lorg/spongepowered/api/plugin/PluginContainer;", "bStats", "Lde/randombyte/holograms/shaded/bstats/sponge/Metrics;", "(Lorg/slf4j/Logger;Ljava/nio/file/Path;Lorg/spongepowered/api/plugin/PluginContainer;Lorg/bstats/sponge/Metrics;)V", "getBStats", "()Lorg/bstats/sponge/Metrics;", "inputFile", "getInputFile", "()Ljava/nio/file/Path;", "onInit", "", "event", "Lorg/spongepowered/api/event/game/state/GameInitializationEvent;", "onPreInit", "Lorg/spongepowered/api/event/game/state/GamePreInitializationEvent;", "onReload", "Lorg/spongepowered/api/event/game/GameReloadEvent;", "safelyCreateFile", "Companion", "holograms"})
public final class Holograms {
    @NotNull
    private final Path inputFile;
    private final Logger logger;
    private final Path configPath;
    private final PluginContainer pluginContainer;
    @NotNull
    private final Metrics bStats;
    @NotNull
    public static final String NAME = "Holograms";
    @NotNull
    public static final String ID = "holograms";
    @NotNull
    public static final String VERSION = "3.1.5";
    @NotNull
    public static final String AUTHOR = "RandomByte";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Path getInputFile() {
        return this.inputFile;
    }

    @Listener
    public final void onPreInit(@NotNull GamePreInitializationEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        Sponge.getServiceManager().setProvider((Object)this, HologramsService.class, (Object)new HologramsServiceImpl());
        HologramKeys.INSTANCE.buildKeys();
        Sponge.getDataManager().registerLegacyManipulatorIds("de.randombyte.holograms.data.HologramData", DataRegistration.builder().dataClass(HologramData.class).immutableClass(HologramData.Immutable.class).builder((DataManipulatorBuilder)new HologramData.Builder()).manipulatorId("holograms-data").dataName("Holograms Data").buildAndRegister(this.pluginContainer));
    }

    @Listener
    public final void onInit(@NotNull GameInitializationEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.safelyCreateFile(this.inputFile);
        Sponge.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().permission("holograms.list").executor((CommandExecutor)new ListNearbyHologramsCommand(this)).arguments(GenericArguments.optional((CommandElement)GenericArguments.integer((Text)StringsKt.toText("maxDistance")))).child((CommandCallable)CommandSpec.builder().permission("holograms.create").arguments(GenericArguments.remainingJoinedStrings((Text)StringsKt.toText("text"))).executor((CommandExecutor)new SpawnTextHologramCommand()).build(), new String[]{"create"}).child((CommandCallable)CommandSpec.builder().permission("holograms.createMultiLine").arguments(GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.doubleNum((Text)StringsKt.toText("verticalSpace")), GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.integer((Text)StringsKt.toText("numberOfLines")), GenericArguments.remainingJoinedStrings((Text)StringsKt.toText("texts"))})})).executor((CommandExecutor)new SpawnMultiLineTextHologramCommand()).build(), new String[]{"createMultiLine", "cml"}).child((CommandCallable)CommandSpec.builder().permission("holograms.list").arguments(GenericArguments.optional((CommandElement)GenericArguments.integer((Text)StringsKt.toText("maxDistance")))).executor((CommandExecutor)new ListNearbyHologramsCommand(this)).build(), new String[]{"list"}).child((CommandCallable)CommandSpec.builder().permission("holograms.setText").arguments(GenericArguments.remainingJoinedStrings((Text)StringsKt.toText("text"))).executor((CommandExecutor)new SetNearestHologramText()).build(), new String[]{"setText"}).build(), new String[]{ID});
        this.logger.info("Holograms loaded: 3.1.5");
    }

    @Listener
    public final void onReload(@NotNull GameReloadEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.safelyCreateFile(this.inputFile);
    }

    private final void safelyCreateFile(@NotNull Path $receiver) {
        if (!Files.exists($receiver, new LinkOption[0])) {
            Files.createDirectories($receiver.getParent(), new FileAttribute[0]);
            Files.createFile($receiver, new FileAttribute[0]);
        }
    }

    @NotNull
    public final Metrics getBStats() {
        return this.bStats;
    }

    @Inject
    public Holograms(@NotNull Logger logger, @ConfigDir(sharedRoot=false) @NotNull Path configPath, @NotNull PluginContainer pluginContainer, @NotNull Metrics bStats) {
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        Intrinsics.checkParameterIsNotNull(configPath, "configPath");
        Intrinsics.checkParameterIsNotNull(pluginContainer, "pluginContainer");
        Intrinsics.checkParameterIsNotNull(bStats, "bStats");
        this.logger = logger;
        this.configPath = configPath;
        this.pluginContainer = pluginContainer;
        this.bStats = bStats;
        Path path = this.configPath.resolve("input.txt");
        Intrinsics.checkExpressionValueIsNotNull(path, "configPath.resolve(\"input.txt\")");
        this.inputFile = path;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/randombyte/holograms/Holograms$Companion;", "", "()V", "AUTHOR", "", "ID", "NAME", "VERSION", "holograms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

