/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.holograms;

import de.randombyte.holograms.HologramsServiceImplKt;
import de.randombyte.holograms.api.HologramsService;
import de.randombyte.holograms.data.HologramData;
import de.randombyte.holograms.data.HologramKeys;
import de.randombyte.holograms.shaded.kosp.extensions.OptionalsKt;
import de.randombyte.holograms.shaded.kosp.extensions.UuidsKt;
import de.randombyte.holograms.shaded.kotlin.Metadata;
import de.randombyte.holograms.shaded.kotlin.Pair;
import de.randombyte.holograms.shaded.kotlin.collections.CollectionsKt;
import de.randombyte.holograms.shaded.kotlin.collections.MapsKt;
import de.randombyte.holograms.shaded.kotlin.comparisons.ComparisonsKt;
import de.randombyte.holograms.shaded.kotlin.jvm.internal.Intrinsics;
import de.randombyte.holograms.shaded.kotlin.ranges.RangesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J2\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\r\u001a\u00020\bH\u0016\u00a8\u0006\u0017"}, d2={"Lde/randombyte/holograms/HologramsServiceImpl;", "Lde/randombyte/holograms/api/HologramsService;", "()V", "createHologram", "Ljava/util/Optional;", "Lde/randombyte/holograms/api/HologramsService$Hologram;", "location", "Lorg/spongepowered/api/world/Location;", "Lorg/spongepowered/api/world/extent/Extent;", "text", "Lorg/spongepowered/api/text/Text;", "getHologram", "Lde/randombyte/holograms/HologramsServiceImpl$HologramImpl;", "extent", "hologramUuid", "Ljava/util/UUID;", "getHolograms", "", "Lde/randombyte/holograms/shaded/kotlin/Pair;", "", "center", "radius", "HologramImpl", "holograms"})
public final class HologramsServiceImpl
implements HologramsService {
    @Override
    @NotNull
    public Optional<HologramsService.Hologram> createHologram(@NotNull Location<? extends Extent> location, @NotNull Text text) {
        Intrinsics.checkParameterIsNotNull(location, "location");
        Intrinsics.checkParameterIsNotNull(text, "text");
        Entity armorStand = location.createEntity(EntityTypes.ARMOR_STAND);
        if (!location.getExtent().spawnEntity(armorStand)) {
            Optional<HologramsService.Hologram> optional = Optional.empty();
            Intrinsics.checkExpressionValueIsNotNull(optional, "Optional.empty()");
            return optional;
        }
        armorStand.offer(Keys.DISPLAY_NAME, (Object)text);
        armorStand.offer(Keys.CUSTOM_NAME_VISIBLE, (Object)true);
        armorStand.offer(Keys.HAS_GRAVITY, (Object)false);
        armorStand.offer(Keys.ARMOR_STAND_MARKER, (Object)true);
        armorStand.offer(Keys.INVISIBLE, (Object)true);
        HologramData data = (HologramData)((HologramData)((Object)armorStand.getOrCreate(HologramData.class).get())).set(HologramKeys.INSTANCE.getIS_HOLOGRAM(), true);
        armorStand.offer((ValueContainer)data);
        Entity entity = armorStand;
        Intrinsics.checkExpressionValueIsNotNull(entity, "armorStand");
        UUID uUID = entity.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID, "armorStand.uniqueId");
        Extent extent = location.getExtent();
        Intrinsics.checkExpressionValueIsNotNull(extent, "location.extent");
        UUID uUID2 = extent.getUniqueId();
        Intrinsics.checkExpressionValueIsNotNull(uUID2, "location.extent.uniqueId");
        return OptionalsKt.toOptional(new HologramImpl(uUID, uUID2));
    }

    @NotNull
    public Optional<HologramImpl> getHologram(@NotNull Extent extent, @NotNull UUID hologramUuid) {
        Object t;
        block1: {
            Intrinsics.checkParameterIsNotNull(extent, "extent");
            Intrinsics.checkParameterIsNotNull(hologramUuid, "hologramUuid");
            Iterable $receiver$iv = this.getHolograms(extent);
            for (Object element$iv : $receiver$iv) {
                HologramImpl it = (HologramImpl)element$iv;
                if (!Intrinsics.areEqual(it.getUuid(), hologramUuid)) continue;
                t = element$iv;
                break block1;
            }
            t = null;
        }
        return OptionalsKt.toOptional(t);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Pair<HologramImpl, Double>> getHolograms(@NotNull Location<? extends Extent> center, double radius) {
        void $receiver$iv$iv;
        Object it;
        void $receiver$iv$iv2;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull(center, "center");
        Extent extent = center.getExtent();
        Intrinsics.checkExpressionValueIsNotNull(extent, "center.extent");
        Iterable iterable = this.getHolograms(extent);
        int capacity$iv232 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        Comparator comparator = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv232);
        for (Object t : $receiver$iv$iv2) {
            HologramImpl hologramImpl = (HologramImpl)t;
            Map map2 = destination$iv$iv;
            void var15_14 = it;
            it = (HologramImpl)t;
            Double d = center.getPosition().distance(((HologramImpl)it).getLocation().getPosition());
            map2.put(var15_14, d);
        }
        $receiver$iv = destination$iv$iv;
        Map capacity$iv232 = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        destination$iv$iv = $receiver$iv$iv;
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            it = entry;
            if (!(((Number)it.getValue()).doubleValue() <= radius)) continue;
            destination$iv$iv2.put(entry.getKey(), entry.getValue());
        }
        $receiver$iv = MapsKt.toList(destination$iv$iv2);
        Object object = $receiver$iv;
        comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                Comparable comparable = Double.valueOf(((Number)it.getSecond()).doubleValue());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                Double d = ((Number)it.getSecond()).doubleValue();
                return ComparisonsKt.compareValues(comparable2, (Comparable)d);
            }
        };
        return CollectionsKt.sortedWith(object, comparator);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<HologramImpl> getHolograms(@NotNull Extent extent) {
        Entity p1;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(extent, "extent");
        Collection collection = extent.getEntities();
        Intrinsics.checkExpressionValueIsNotNull(collection, "extent.entities");
        Iterable $receiver$iv = collection;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            p1 = (Entity)element$iv$iv;
            if (!HologramsServiceImplKt.access$isHologram(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            p1 = (Entity)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull(v1, "it");
            UUID uUID = v1.getUniqueId();
            Intrinsics.checkExpressionValueIsNotNull(uUID, "it.uniqueId");
            UUID uUID2 = extent.getUniqueId();
            Intrinsics.checkExpressionValueIsNotNull(uUID2, "extent.uniqueId");
            HologramImpl hologramImpl = new HologramImpl(uUID, uUID2);
            collection2.add(hologramImpl);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Optional<List<HologramsService.Hologram>> createMultilineHologram(@NotNull Location<? extends Extent> lowestLocation, @NotNull List<? extends Text> texts, double verticalSpace) {
        Intrinsics.checkParameterIsNotNull(lowestLocation, "lowestLocation");
        Intrinsics.checkParameterIsNotNull(texts, "texts");
        return HologramsService.DefaultImpls.createMultilineHologram(this, lowestLocation, texts, verticalSpace);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R0\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lde/randombyte/holograms/HologramsServiceImpl$HologramImpl;", "Lde/randombyte/holograms/api/HologramsService$Hologram;", "uuid", "Ljava/util/UUID;", "worldUuid", "(Ljava/util/UUID;Ljava/util/UUID;)V", "value", "Lorg/spongepowered/api/world/Location;", "Lorg/spongepowered/api/world/World;", "location", "getLocation", "()Lorg/spongepowered/api/world/Location;", "setLocation", "(Lorg/spongepowered/api/world/Location;)V", "Lorg/spongepowered/api/text/Text;", "text", "getText", "()Lorg/spongepowered/api/text/Text;", "setText", "(Lorg/spongepowered/api/text/Text;)V", "exists", "", "getArmorStand", "Lorg/spongepowered/api/entity/living/ArmorStand;", "remove", "", "holograms"})
    public static final class HologramImpl
    extends HologramsService.Hologram {
        @Override
        @NotNull
        public Location<World> getLocation() {
            Location location = this.getArmorStand().getLocation();
            Intrinsics.checkExpressionValueIsNotNull(location, "getArmorStand().location");
            return location;
        }

        @Override
        public void setLocation(@NotNull Location<World> value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            this.getArmorStand().setLocation(value);
        }

        @Override
        @NotNull
        public Text getText() {
            Text text = this.getArmorStand().get(Keys.DISPLAY_NAME).orElse(Text.EMPTY);
            Intrinsics.checkExpressionValueIsNotNull(text, "getArmorStand().get(Keys\u2026_NAME).orElse(Text.EMPTY)");
            return text;
        }

        @Override
        public void setText(@NotNull Text value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            this.getArmorStand().offer(Keys.DISPLAY_NAME, (Object)value);
        }

        @Override
        public boolean exists() {
            Object object = UuidsKt.getWorld(this.getWorldUuid());
            return object != null && (object = object.getEntity(this.getUuid())) != null && (object = (Entity)OptionalsKt.orNull(object)) != null ? HologramsServiceImplKt.access$isHologram((Entity)object) : false;
        }

        @Override
        public void remove() {
            this.getArmorStand().remove();
        }

        @Override
        @NotNull
        public ArmorStand getArmorStand() {
            World world = UuidsKt.getWorld(this.getWorldUuid());
            if (world == null) {
                throw (Throwable)new RuntimeException("Can't find world '" + this.getWorldUuid() + "'!");
            }
            World world2 = world;
            Optional optional = world2.getEntity(this.getUuid());
            Intrinsics.checkExpressionValueIsNotNull(optional, "world.getEntity(uuid)");
            Entity entity = (Entity)OptionalsKt.orNull(optional);
            if (entity == null) {
                throw (Throwable)new RuntimeException("Can't find Entity '" + this.getUuid() + "' in world '" + this.getWorldUuid() + "'!");
            }
            Entity entity2 = entity;
            Entity entity3 = entity2;
            if (!(entity3 instanceof ArmorStand)) {
                entity3 = null;
            }
            ArmorStand armorStand = (ArmorStand)entity3;
            if (armorStand == null) {
                throw (Throwable)new RuntimeException("Entity '" + this.getUuid() + "' in world '" + this.getWorldUuid() + "' is not an ArmorStand!");
            }
            ArmorStand armorStand2 = armorStand;
            if (!HologramsServiceImplKt.access$isHologram((Entity)armorStand2)) {
                throw (Throwable)new RuntimeException("ArmorStand '" + this.getUuid() + "' in world '" + this.getWorldUuid() + "' is not a Hologram!");
            }
            return armorStand2;
        }

        public HologramImpl(@NotNull UUID uuid, @NotNull UUID worldUuid) {
            Intrinsics.checkParameterIsNotNull(uuid, "uuid");
            Intrinsics.checkParameterIsNotNull(worldUuid, "worldUuid");
            super(uuid, worldUuid);
            this.getArmorStand();
        }
    }
}

