/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.holograms.commands;

import de.randombyte.holograms.api.HologramsService;
import de.randombyte.holograms.shaded.kosp.PlayerExecutedCommand;
import de.randombyte.holograms.shaded.kosp.extensions.CommandsSourcesKt;
import de.randombyte.holograms.shaded.kosp.extensions.KClassKt;
import de.randombyte.holograms.shaded.kosp.extensions.StringsKt;
import de.randombyte.holograms.shaded.kotlin.Metadata;
import de.randombyte.holograms.shaded.kotlin.Pair;
import de.randombyte.holograms.shaded.kotlin.collections.CollectionsKt;
import de.randombyte.holograms.shaded.kotlin.jvm.internal.Intrinsics;
import de.randombyte.holograms.shaded.kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lde/randombyte/holograms/commands/SetNearestHologramText;", "Lde/randombyte/holograms/shaded/kosp/PlayerExecutedCommand;", "()V", "errorText", "Lorg/spongepowered/api/text/Text;", "getErrorText", "()Lorg/spongepowered/api/text/Text;", "executedByPlayer", "Lorg/spongepowered/api/command/CommandResult;", "player", "Lorg/spongepowered/api/entity/living/player/Player;", "args", "Lorg/spongepowered/api/command/args/CommandContext;", "holograms"})
public final class SetNearestHologramText
extends PlayerExecutedCommand {
    @NotNull
    private final Text errorText = StringsKt.toText("No nearby Hologram found! Please move closely or teleport to one.");

    @NotNull
    public final Text getErrorText() {
        return this.errorText;
    }

    @Override
    @NotNull
    public CommandResult executedByPlayer(@NotNull Player player, @NotNull CommandContext args) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(args, "args");
        HologramsService hologramsService = (HologramsService)KClassKt.getServiceOrFail$default(Reflection.getOrCreateKotlinClass(HologramsService.class), null, 1, null);
        Location location = player.getLocation();
        Intrinsics.checkExpressionValueIsNotNull(location, "player.location");
        Pair<HologramsService.Hologram, Double> pair = CollectionsKt.firstOrNull(hologramsService.getHolograms((Location<? extends Extent>)location, 1.0));
        if (pair == null || (pair = pair.getFirst()) == null) {
            throw (Throwable)new CommandException(this.errorText);
        }
        Pair<HologramsService.Hologram, Double> nearestHologram = pair;
        Object t = args.getOne("text").get();
        Intrinsics.checkExpressionValueIsNotNull(t, "args.getOne<String>(\"text\").get()");
        Text text = StringsKt.deserialize((String)t);
        ((HologramsService.Hologram)((Object)nearestHologram)).setText(text);
        CommandsSourcesKt.executeCommand((CommandSource)player, "holograms list");
        CommandResult commandResult = CommandResult.success();
        Intrinsics.checkExpressionValueIsNotNull(commandResult, "CommandResult.success()");
        return commandResult;
    }
}

