/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.holograms.shaded.kosp.config.serializers.date;

import com.google.common.reflect.TypeToken;
import de.randombyte.holograms.shaded.kotlin.Metadata;
import de.randombyte.holograms.shaded.kotlin.jvm.internal.Intrinsics;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\u00022\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u0010\u001a\u00020\u00112\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/randombyte/holograms/shaded/kosp/config/serializers/date/SimpleDateTypeSerializer;", "Lninja/leaping/configurate/objectmapping/serialize/TypeSerializer;", "Ljava/util/Date;", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "legacyDateFormat", "deserialize", "type", "Lcom/google/common/reflect/TypeToken;", "value", "Lninja/leaping/configurate/ConfigurationNode;", "string", "", "deserializeLegacy", "de.randombyte.holograms.shaded.kotlin.jvm.PlatformType", "serialize", "", "date", "kosp"})
public final class SimpleDateTypeSerializer
implements TypeSerializer<Date> {
    private static final SimpleDateFormat legacyDateFormat;
    private static final SimpleDateFormat dateFormat;
    public static final SimpleDateTypeSerializer INSTANCE;

    @NotNull
    public Date deserialize(@NotNull TypeToken<?> type, @NotNull ConfigurationNode value) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        Intrinsics.checkParameterIsNotNull(value, "value");
        String string = value.getString();
        Intrinsics.checkExpressionValueIsNotNull(string, "value.string");
        return this.deserialize(string);
    }

    public void serialize(@NotNull TypeToken<?> type, @NotNull Date date, @NotNull ConfigurationNode value) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        Intrinsics.checkParameterIsNotNull(date, "date");
        Intrinsics.checkParameterIsNotNull(value, "value");
        value.setValue((Object)this.serialize(date));
    }

    @NotNull
    public final Date deserialize(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        try {
            Date date = dateFormat.parse(string);
            Intrinsics.checkExpressionValueIsNotNull(date, "dateFormat.parse(string)");
            return date;
        }
        catch (ParseException exception) {
            try {
                Date date = this.deserializeLegacy(string);
                Intrinsics.checkExpressionValueIsNotNull(date, "deserializeLegacy(string)");
                return date;
            }
            catch (ParseException parseException) {
                throw (Throwable)new ObjectMappingException("Invalid input value '" + string + "' for a date like this: '21:18:25.300-28.03.2017'", (Throwable)exception);
            }
        }
    }

    @NotNull
    public final String serialize(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull(date, "date");
        String string = dateFormat.format(date);
        Intrinsics.checkExpressionValueIsNotNull(string, "dateFormat.format(date)");
        return string;
    }

    private final Date deserializeLegacy(String string) {
        return legacyDateFormat.parse(string);
    }

    private SimpleDateTypeSerializer() {
    }

    static {
        SimpleDateTypeSerializer simpleDateTypeSerializer;
        INSTANCE = simpleDateTypeSerializer = new SimpleDateTypeSerializer();
        legacyDateFormat = new SimpleDateFormat("HH:mm:ss.SSS dd.MM.yyyy");
        dateFormat = new SimpleDateFormat("HH:mm:ss.SSS-dd.MM.yyyy");
    }
}

