/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import java.util.Comparator;
import java.util.Optional;
import net.luckperms.api.actionlog.Action;

final class ActionComparator
implements Comparator<Action> {
    public static final Comparator<Action> INSTANCE = new ActionComparator();

    private ActionComparator() {
    }

    @Override
    public int compare(Action o1, Action o2) {
        int cmp = o1.getTimestamp().compareTo(o2.getTimestamp());
        if (cmp != 0) {
            return cmp;
        }
        Action.Source o1Source = o1.getSource();
        Action.Source o2Source = o2.getSource();
        cmp = o1Source.getUniqueId().compareTo(o2Source.getUniqueId());
        if (cmp != 0) {
            return cmp;
        }
        cmp = o1Source.getName().compareTo(o2Source.getName());
        if (cmp != 0) {
            return cmp;
        }
        Action.Target o1Target = o1.getTarget();
        Action.Target o2Target = o2.getTarget();
        cmp = o1Target.getType().compareTo(o2Target.getType());
        if (cmp != 0) {
            return cmp;
        }
        cmp = o1Target.getType().compareTo(o2Target.getType());
        if (cmp != 0) {
            return cmp;
        }
        cmp = ActionComparator.compareOptionals(o1Target.getUniqueId(), o2Target.getUniqueId());
        if (cmp != 0) {
            return cmp;
        }
        cmp = o1Source.getName().compareTo(o2Source.getName());
        if (cmp != 0) {
            return cmp;
        }
        return o1.getDescription().compareTo(o2.getDescription());
    }

    private static <T extends Comparable<T>> int compareOptionals(Optional<T> a, Optional<T> b) {
        if (!a.isPresent()) {
            return b.isPresent() ? -1 : 0;
        }
        if (!b.isPresent()) {
            return 1;
        }
        return ((Comparable)a.get()).compareTo(b.get());
    }
}

