/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.commands.log.LogNotify;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import net.luckperms.api.event.log.LogBroadcastEvent;
import net.luckperms.api.event.log.LogNotifyEvent;

public class LogDispatcher {
    private final LuckPermsPlugin plugin;

    public LogDispatcher(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    private void broadcast(LoggedAction entry, LogNotifyEvent.Origin origin, Sender sender) {
        this.plugin.getOnlineSenders().filter(CommandPermission.LOG_NOTIFY::isAuthorized).filter(s -> {
            boolean shouldCancel = LogNotify.isIgnoring(this.plugin, s.getUniqueId()) || sender != null && s.getUniqueId().equals(sender.getUniqueId());
            return !this.plugin.getEventDispatcher().dispatchLogNotify(shouldCancel, entry, origin, (Sender)s);
        }).forEach(s -> Message.LOG.send((Sender)s, entry.getSourceFriendlyString(), Character.toString(LoggedAction.getTypeCharacter(entry.getTarget().getType())), entry.getTargetFriendlyString(), entry.getDescription()));
    }

    public void dispatch(LoggedAction entry, Sender sender) {
        boolean shouldCancel;
        if (!this.plugin.getEventDispatcher().dispatchLogPublish(false, entry)) {
            this.plugin.getStorage().logAction(entry);
        }
        this.plugin.getMessagingService().ifPresent(service -> service.pushLog(entry));
        boolean bl = shouldCancel = this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY) == false;
        if (!this.plugin.getEventDispatcher().dispatchLogBroadcast(shouldCancel, entry, LogBroadcastEvent.Origin.LOCAL)) {
            this.broadcast(entry, LogNotifyEvent.Origin.LOCAL, sender);
        }
    }

    public void dispatchFromApi(LoggedAction entry) {
        if (!this.plugin.getEventDispatcher().dispatchLogPublish(false, entry)) {
            try {
                this.plugin.getStorage().logAction(entry).get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.broadcastFromApi(entry);
    }

    public void broadcastFromApi(LoggedAction entry) {
        boolean shouldCancel;
        this.plugin.getMessagingService().ifPresent(extendedMessagingService -> extendedMessagingService.pushLog(entry));
        boolean bl = shouldCancel = this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY) == false;
        if (!this.plugin.getEventDispatcher().dispatchLogBroadcast(shouldCancel, entry, LogBroadcastEvent.Origin.LOCAL_API)) {
            this.broadcast(entry, LogNotifyEvent.Origin.LOCAL_API, null);
        }
    }

    public void dispatchFromRemote(LoggedAction entry) {
        boolean shouldCancel;
        boolean bl = shouldCancel = this.plugin.getConfiguration().get(ConfigKeys.BROADCAST_RECEIVED_LOG_ENTRIES) == false || this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY) == false;
        if (!this.plugin.getEventDispatcher().dispatchLogBroadcast(shouldCancel, entry, LogBroadcastEvent.Origin.REMOTE)) {
            this.broadcast(entry, LogNotifyEvent.Origin.REMOTE, null);
        }
    }
}

