/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import com.google.common.base.Strings;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.ActionComparator;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LoggedAction
implements Action {
    private final long timestamp;
    private final SourceImpl source;
    private final TargetImpl target;
    private final String description;

    public static Builder build() {
        return new Builder();
    }

    private LoggedAction(long timestamp, UUID sourceUniqueId, String sourceName, UUID targetUniqueId, String targetName, Action.Target.Type targetType, String description) {
        this.timestamp = timestamp;
        this.source = new SourceImpl(sourceUniqueId, sourceName);
        this.target = new TargetImpl(targetUniqueId, targetName, targetType);
        this.description = description;
    }

    @Override
    public @NonNull Instant getTimestamp() {
        return Instant.ofEpochSecond(this.timestamp);
    }

    public Duration getDurationSince() {
        return Duration.between(this.getTimestamp(), Instant.now());
    }

    @Override
    public @NonNull Action.Source getSource() {
        return this.source;
    }

    @Override
    public @NonNull Action.Target getTarget() {
        return this.target;
    }

    public String getSourceFriendlyString() {
        if (Strings.isNullOrEmpty((String)this.source.name) || this.source.name.equals("null")) {
            return this.source.uniqueId.toString();
        }
        return this.source.name;
    }

    public String getTargetFriendlyString() {
        if ((Strings.isNullOrEmpty((String)this.target.name) || this.target.name.equals("null")) && this.target.uniqueId != null) {
            return this.target.uniqueId.toString();
        }
        return String.valueOf(this.target.name);
    }

    @Override
    public @NonNull String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(@NonNull Action other) {
        Objects.requireNonNull(other, "other");
        return ActionComparator.INSTANCE.compare(this, other);
    }

    public boolean matchesSearch(String query) {
        query = Objects.requireNonNull(query, "query").toLowerCase();
        return this.source.name.toLowerCase().contains(query) || this.target.name.toLowerCase().contains(query) || this.description.toLowerCase().contains(query);
    }

    public void submit(LuckPermsPlugin plugin, Sender sender) {
        plugin.getLogDispatcher().dispatch(this, sender);
    }

    public String toString() {
        return "LoggedAction(timestamp=" + this.getTimestamp() + ", source=" + this.getSource().getUniqueId() + ", sourceName=" + this.getSource().getName() + ", target=" + this.getTarget().getUniqueId() + ", targetName=" + this.getTarget().getName() + ", targetType=" + (Object)((Object)this.getTarget().getType()) + ", description=" + this.getDescription() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action that = (Action)o;
        return this.getTimestamp().equals(that.getTimestamp()) && this.getSource().equals(that.getSource()) && this.getTarget().equals(that.getTarget()) && this.getDescription().equals(that.getDescription());
    }

    public int hashCode() {
        return Objects.hash(this.getTimestamp(), this.getSource(), this.getTarget(), this.getDescription());
    }

    public static @NonNull Action.Target.Type parseType(String type) {
        try {
            return Action.Target.Type.valueOf(type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return LoggedAction.parseTypeCharacter(type.charAt(0));
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        }
    }

    public static @NonNull Action.Target.Type parseTypeCharacter(char code) {
        switch (code) {
            case 'U': 
            case 'u': {
                return Action.Target.Type.USER;
            }
            case 'G': 
            case 'g': {
                return Action.Target.Type.GROUP;
            }
            case 'T': 
            case 't': {
                return Action.Target.Type.TRACK;
            }
        }
        throw new IllegalArgumentException("Unknown code: " + code);
    }

    public static char getTypeCharacter(Action.Target.Type type) {
        switch (type) {
            case USER: {
                return 'U';
            }
            case GROUP: {
                return 'G';
            }
            case TRACK: {
                return 'T';
            }
        }
        throw new AssertionError();
    }

    public static class Builder
    implements Action.Builder {
        private long timestamp = 0L;
        private UUID sourceUniqueId = null;
        private String sourceName = null;
        private UUID targetUniqueId = null;
        private String targetName = null;
        private Action.Target.Type targetType = null;
        private String description = null;

        @Override
        public @NonNull Builder timestamp(@NonNull Instant timestamp) {
            this.timestamp = timestamp.getEpochSecond();
            return this;
        }

        @Override
        public @NonNull Builder source(@NonNull UUID source) {
            this.sourceUniqueId = Objects.requireNonNull(source, "source");
            return this;
        }

        @Override
        public @NonNull Builder sourceName(@NonNull String sourceName) {
            this.sourceName = Objects.requireNonNull(sourceName, "sourceName");
            return this;
        }

        @Override
        public @NonNull Builder targetType(Action.Target.Type type) {
            this.targetType = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public @NonNull Builder target(UUID target) {
            this.targetUniqueId = target;
            return this;
        }

        @Override
        public @NonNull Builder targetName(@NonNull String targetName) {
            this.targetName = Objects.requireNonNull(targetName, "targetName");
            return this;
        }

        @Override
        public @NonNull Builder description(@NonNull String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        public Builder source(Sender source) {
            this.sourceName(source.getNameWithLocation());
            this.source(source.getUniqueId());
            return this;
        }

        public Builder target(PermissionHolder target) {
            if (target.getType() == HolderType.USER) {
                this.targetName(((User)target).getUsername().orElse("null"));
                this.target(((User)target).getUniqueId());
                this.targetType(Action.Target.Type.USER);
            } else if (target.getType() == HolderType.GROUP) {
                this.targetName(((Group)target).getName());
                this.targetType(Action.Target.Type.GROUP);
            }
            return this;
        }

        public Builder target(Track track) {
            this.targetName(track.getName());
            this.targetType(Action.Target.Type.TRACK);
            return this;
        }

        public Builder description(Object ... args) {
            ArrayList<String> parts = new ArrayList<String>();
            for (Object o : args) {
                if (o instanceof ContextSet) {
                    ContextSet set = (ContextSet)o;
                    for (String value : set.getValues("server")) {
                        parts.add("server=" + value);
                    }
                    for (String value : set.getValues("world")) {
                        parts.add("world=" + value);
                    }
                    for (Context context : set) {
                        if (context.getKey().equals("server") || context.getKey().equals("world")) continue;
                        parts.add(context.getKey() + "=" + context.getValue());
                    }
                    continue;
                }
                parts.add(String.valueOf(o));
            }
            this.description(String.join((CharSequence)" ", parts));
            return this;
        }

        @Override
        public @NonNull LoggedAction build() {
            if (this.timestamp == 0L) {
                this.timestamp(Instant.now());
            }
            Objects.requireNonNull(this.sourceUniqueId, "sourceUniqueId");
            Objects.requireNonNull(this.sourceName, "sourceName");
            Objects.requireNonNull(this.targetType, "targetType");
            Objects.requireNonNull(this.targetName, "targetName");
            Objects.requireNonNull(this.description, "description");
            return new LoggedAction(this.timestamp, this.sourceUniqueId, this.sourceName, this.targetUniqueId, this.targetName, this.targetType, this.description);
        }
    }

    private static final class TargetImpl
    implements Action.Target {
        private final UUID uniqueId;
        private final String name;
        private final Action.Target.Type type;

        private TargetImpl(UUID uniqueId, String name, Action.Target.Type type) {
            this.uniqueId = uniqueId;
            this.name = name;
            this.type = type;
        }

        @Override
        public @NonNull Optional<UUID> getUniqueId() {
            return Optional.ofNullable(this.uniqueId);
        }

        @Override
        public @NonNull String getName() {
            return this.name;
        }

        @Override
        public @NonNull Action.Target.Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TargetImpl target = (TargetImpl)o;
            return Objects.equals(this.uniqueId, target.uniqueId) && this.name.equals(target.name) && this.type == target.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.uniqueId, this.name, this.type});
        }
    }

    private static final class SourceImpl
    implements Action.Source {
        private final UUID uniqueId;
        private final String name;

        private SourceImpl(UUID uniqueId, String name) {
            this.uniqueId = uniqueId;
            this.name = name;
        }

        @Override
        public @NonNull UUID getUniqueId() {
            return this.uniqueId;
        }

        @Override
        public @NonNull String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceImpl source = (SourceImpl)o;
            return this.uniqueId.equals(source.uniqueId) && this.name.equals(source.name);
        }

        public int hashCode() {
            return Objects.hash(this.uniqueId, this.name);
        }
    }
}

