/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import com.google.common.collect.ImmutableListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import me.lucko.luckperms.common.api.ApiUtils;
import me.lucko.luckperms.common.api.implementation.ApiAbstractManager;
import me.lucko.luckperms.common.api.implementation.ApiGroup;
import me.lucko.luckperms.common.model.manager.group.GroupManager;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.event.cause.DeletionCause;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.node.HeldNode;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.matcher.NodeMatcher;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiGroupManager
extends ApiAbstractManager<me.lucko.luckperms.common.model.Group, Group, GroupManager<?>>
implements net.luckperms.api.model.group.GroupManager {
    public ApiGroupManager(LuckPermsPlugin plugin, GroupManager<?> handle) {
        super(plugin, handle);
    }

    @Override
    protected Group proxy(me.lucko.luckperms.common.model.Group internal) {
        return internal == null ? null : internal.getApiProxy();
    }

    @Override
    public @NonNull CompletableFuture<Group> createAndLoadGroup(@NonNull String name) {
        name = ApiUtils.checkName(Objects.requireNonNull(name, "name"));
        return this.plugin.getStorage().createAndLoadGroup(name, CreationCause.API).thenApply(this::proxy);
    }

    @Override
    public @NonNull CompletableFuture<Optional<Group>> loadGroup(@NonNull String name) {
        name = ApiUtils.checkName(Objects.requireNonNull(name, "name"));
        return this.plugin.getStorage().loadGroup(name).thenApply(opt -> opt.map(this::proxy));
    }

    @Override
    public @NonNull CompletableFuture<Void> saveGroup(@NonNull Group group) {
        Objects.requireNonNull(group, "group");
        return this.plugin.getStorage().saveGroup(ApiGroup.cast(group));
    }

    @Override
    public @NonNull CompletableFuture<Void> deleteGroup(@NonNull Group group) {
        Objects.requireNonNull(group, "group");
        if (group.getName().equalsIgnoreCase("default")) {
            throw new IllegalArgumentException("Cannot delete the default group.");
        }
        return this.plugin.getStorage().deleteGroup(ApiGroup.cast(group), DeletionCause.API);
    }

    @Override
    public @NonNull CompletableFuture<Void> modifyGroup(@NonNull String name, @NonNull Consumer<? super Group> action) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(action, "action");
        return ((CompletableFuture)this.plugin.getStorage().createAndLoadGroup(name, CreationCause.API).thenApplyAsync(group -> {
            action.accept(group.getApiProxy());
            return group;
        }, this.plugin.getBootstrap().getScheduler().async())).thenCompose(group -> this.plugin.getStorage().saveGroup((me.lucko.luckperms.common.model.Group)group));
    }

    @Override
    public @NonNull CompletableFuture<Void> loadAllGroups() {
        return this.plugin.getStorage().loadAllGroups();
    }

    @Override
    @Deprecated
    public @NonNull CompletableFuture<List<HeldNode<String>>> getWithPermission(@NonNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return this.plugin.getStorage().getUsersWithPermission(StandardNodeMatchers.key(permission));
    }

    @Override
    public <T extends Node> @NonNull CompletableFuture<Map<String, Collection<T>>> searchAll(@NonNull NodeMatcher<? extends T> matcher) {
        Objects.requireNonNull(matcher, "matcher");
        ConstraintNodeMatcher constraint = (ConstraintNodeMatcher)matcher;
        return this.plugin.getStorage().getGroupsWithPermission(constraint).thenApply(list -> {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (NodeEntry row : list) {
                builder.put(row.getHolder(), row.getNode());
            }
            return builder.build().asMap();
        });
    }

    @Override
    public Group getGroup(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return this.proxy((me.lucko.luckperms.common.model.Group)((GroupManager)this.handle).getIfLoaded(name));
    }

    @Override
    public @NonNull Set<Group> getLoadedGroups() {
        return (Set)((GroupManager)this.handle).getAll().values().stream().map(this::proxy).collect(ImmutableCollectors.toSet());
    }

    @Override
    public boolean isLoaded(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return ((GroupManager)this.handle).isLoaded(name);
    }
}

