/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Predicate;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import net.luckperms.api.cacheddata.CachedDataManager;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.model.data.NodeMap;
import net.luckperms.api.model.data.TemporaryNodeMergeStrategy;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiPermissionHolder
implements net.luckperms.api.model.PermissionHolder {
    private final PermissionHolder handle;
    private final NodeMapImpl normalData;
    private final NodeMapImpl transientData;

    ApiPermissionHolder(PermissionHolder handle) {
        this.handle = Objects.requireNonNull(handle, "handle");
        this.normalData = new NodeMapImpl(DataType.NORMAL);
        this.transientData = new NodeMapImpl(DataType.TRANSIENT);
    }

    PermissionHolder getHandle() {
        return this.handle;
    }

    protected void onNodeChange() {
    }

    @Override
    public  @NonNull PermissionHolder.Identifier getIdentifier() {
        return this.handle.getIdentifier();
    }

    @Override
    public @NonNull String getFriendlyName() {
        return this.handle.getPlainDisplayName();
    }

    @Override
    public @NonNull QueryOptions getQueryOptions() {
        return this.handle.getQueryOptions();
    }

    @Override
    public @NonNull CachedDataManager getCachedData() {
        return this.handle.getCachedData();
    }

    @Override
    public @NonNull NodeMap getData(@NonNull DataType dataType) {
        switch (dataType) {
            case NORMAL: {
                return this.normalData;
            }
            case TRANSIENT: {
                return this.transientData;
            }
        }
        throw new AssertionError();
    }

    @Override
    public @NonNull NodeMap data() {
        return this.normalData;
    }

    @Override
    public @NonNull NodeMap transientData() {
        return this.transientData;
    }

    public @NonNull List<Node> getNodes() {
        return this.handle.getOwnNodes(QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
    }

    @Override
    public <T extends Node> @NonNull Collection<T> getNodes(@NonNull NodeType<T> type) {
        Objects.requireNonNull(type, "type");
        return this.handle.getOwnNodes(type, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
    }

    @Override
    public @NonNull SortedSet<Node> getDistinctNodes() {
        return this.handle.getOwnNodesSorted(QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
    }

    public @NonNull List<Node> resolveInheritedNodes(@NonNull QueryOptions queryOptions) {
        Objects.requireNonNull(queryOptions, "queryOptions");
        return this.handle.resolveInheritedNodes(queryOptions);
    }

    @Override
    public <T extends Node> @NonNull Collection<T> resolveInheritedNodes(@NonNull NodeType<T> type, @NonNull QueryOptions queryOptions) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(queryOptions, "queryOptions");
        return this.handle.resolveInheritedNodes(type, queryOptions);
    }

    @Override
    public @NonNull SortedSet<Node> resolveDistinctInheritedNodes(@NonNull QueryOptions queryOptions) {
        Objects.requireNonNull(queryOptions, "queryOptions");
        return this.handle.resolveInheritedNodesSorted(queryOptions);
    }

    @Override
    public @NonNull Collection<Group> getInheritedGroups(@NonNull QueryOptions queryOptions) {
        Objects.requireNonNull(queryOptions, "queryOptions");
        return (Collection)this.handle.resolveInheritanceTree(queryOptions).stream().map(me.lucko.luckperms.common.model.Group::getApiProxy).collect(ImmutableCollectors.toList());
    }

    @Override
    public void auditTemporaryNodes() {
        this.handle.auditTemporaryNodes();
    }

    private class NodeMapImpl
    implements NodeMap {
        private final DataType dataType;

        NodeMapImpl(DataType dataType) {
            this.dataType = dataType;
        }

        @Override
        public @NonNull Map<ImmutableContextSet, Collection<Node>> toMap() {
            return ApiPermissionHolder.this.handle.getData(this.dataType).immutable().asMap();
        }

        public @NonNull Set<Node> toCollection() {
            return ApiPermissionHolder.this.handle.getData(this.dataType).asSet();
        }

        @Override
        public @NonNull Tristate contains(@NonNull Node node, @NonNull NodeEqualityPredicate equalityPredicate) {
            Objects.requireNonNull(node, "node");
            Objects.requireNonNull(equalityPredicate, "equalityPredicate");
            return ApiPermissionHolder.this.handle.hasNode(this.dataType, node, equalityPredicate);
        }

        @Override
        public @NonNull DataMutateResult add(@NonNull Node node) {
            Objects.requireNonNull(node, "node");
            DataMutateResult result = ApiPermissionHolder.this.handle.setNode(this.dataType, node, true);
            if (result.wasSuccessful()) {
                ApiPermissionHolder.this.onNodeChange();
            }
            return result;
        }

        @Override
        public @NonNull DataMutateResult.WithMergedNode add(@NonNull Node node, @NonNull TemporaryNodeMergeStrategy temporaryNodeMergeStrategy) {
            Objects.requireNonNull(node, "node");
            Objects.requireNonNull(temporaryNodeMergeStrategy, "temporaryNodeMergeStrategy");
            DataMutateResult.WithMergedNode result = ApiPermissionHolder.this.handle.setNode(this.dataType, node, temporaryNodeMergeStrategy);
            if (result.getResult().wasSuccessful()) {
                ApiPermissionHolder.this.onNodeChange();
            }
            return result;
        }

        @Override
        public @NonNull DataMutateResult remove(@NonNull Node node) {
            Objects.requireNonNull(node, "node");
            DataMutateResult result = ApiPermissionHolder.this.handle.unsetNode(this.dataType, node);
            if (result.wasSuccessful()) {
                ApiPermissionHolder.this.onNodeChange();
            }
            return result;
        }

        @Override
        public void clear() {
            if (ApiPermissionHolder.this.handle.clearNodes(this.dataType, null, true)) {
                ApiPermissionHolder.this.onNodeChange();
            }
        }

        @Override
        public void clear(@NonNull Predicate<? super Node> test) {
            Objects.requireNonNull(test, "test");
            if (ApiPermissionHolder.this.handle.removeIf(this.dataType, null, test, true)) {
                ApiPermissionHolder.this.onNodeChange();
            }
        }

        @Override
        public void clear(@NonNull ContextSet contextSet) {
            Objects.requireNonNull(contextSet, "contextSet");
            if (ApiPermissionHolder.this.handle.clearNodes(this.dataType, contextSet, true)) {
                ApiPermissionHolder.this.onNodeChange();
            }
        }

        @Override
        public void clear(@NonNull ContextSet contextSet, @NonNull Predicate<? super Node> test) {
            Objects.requireNonNull(contextSet, "contextSet");
            Objects.requireNonNull(test, "test");
            if (ApiPermissionHolder.this.handle.removeIf(this.dataType, contextSet, test, true)) {
                ApiPermissionHolder.this.onNodeChange();
            }
        }
    }
}

