/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import com.google.common.collect.ImmutableListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import me.lucko.luckperms.common.api.ApiUtils;
import me.lucko.luckperms.common.api.implementation.ApiAbstractManager;
import me.lucko.luckperms.common.api.implementation.ApiUser;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.node.HeldNode;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.matcher.NodeMatcher;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ApiUserManager
extends ApiAbstractManager<User, net.luckperms.api.model.user.User, me.lucko.luckperms.common.model.manager.user.UserManager<?>>
implements UserManager {
    public ApiUserManager(LuckPermsPlugin plugin, me.lucko.luckperms.common.model.manager.user.UserManager<?> handle) {
        super(plugin, handle);
    }

    @Override
    protected net.luckperms.api.model.user.User proxy(User internal) {
        return internal == null ? null : internal.getApiProxy();
    }

    @Override
    public @NonNull CompletableFuture<net.luckperms.api.model.user.User> loadUser(@NonNull UUID uniqueId, @Nullable String username) {
        Objects.requireNonNull(uniqueId, "uuid");
        ApiUtils.checkUsername(username, this.plugin);
        if (this.plugin.getUserManager().getIfLoaded(uniqueId) == null) {
            this.plugin.getUserManager().getHouseKeeper().registerApiUsage(uniqueId);
        }
        return this.plugin.getStorage().loadUser(uniqueId, username).thenApply(this::proxy);
    }

    @Override
    public @NonNull CompletableFuture<UUID> lookupUniqueId(@NonNull String username) {
        Objects.requireNonNull(username, "username");
        return this.plugin.getStorage().getPlayerUniqueId(username);
    }

    @Override
    public @NonNull CompletableFuture<String> lookupUsername(@NonNull UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uuid");
        return this.plugin.getStorage().getPlayerName(uniqueId);
    }

    @Override
    public @NonNull CompletableFuture<Void> saveUser(@NonNull net.luckperms.api.model.user.User user) {
        Objects.requireNonNull(user, "user");
        return this.plugin.getStorage().saveUser(ApiUser.cast(user));
    }

    @Override
    public @NonNull CompletableFuture<Void> modifyUser(@NonNull UUID uniqueId, @NonNull Consumer<? super net.luckperms.api.model.user.User> action) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        Objects.requireNonNull(action, "action");
        return ((CompletableFuture)this.plugin.getStorage().loadUser(uniqueId, null).thenApplyAsync(user -> {
            action.accept(user.getApiProxy());
            return user;
        }, this.plugin.getBootstrap().getScheduler().async())).thenCompose(user -> this.plugin.getStorage().saveUser((User)user));
    }

    @Override
    public @NonNull CompletableFuture<PlayerSaveResult> savePlayerData(@NonNull UUID uniqueId, @NonNull String username) {
        Objects.requireNonNull(uniqueId, "uuid");
        Objects.requireNonNull(username, "username");
        return this.plugin.getStorage().savePlayerData(uniqueId, username);
    }

    @Override
    public @NonNull CompletableFuture<Set<UUID>> getUniqueUsers() {
        return this.plugin.getStorage().getUniqueUsers();
    }

    @Override
    @Deprecated
    public @NonNull CompletableFuture<List<HeldNode<UUID>>> getWithPermission(@NonNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return this.plugin.getStorage().getUsersWithPermission(StandardNodeMatchers.key(permission));
    }

    @Override
    public <T extends Node> @NonNull CompletableFuture<Map<UUID, Collection<T>>> searchAll(@NonNull NodeMatcher<? extends T> matcher) {
        Objects.requireNonNull(matcher, "matcher");
        ConstraintNodeMatcher constraint = (ConstraintNodeMatcher)matcher;
        return this.plugin.getStorage().getUsersWithPermission(constraint).thenApply(list -> {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (NodeEntry row : list) {
                builder.put(row.getHolder(), row.getNode());
            }
            return builder.build().asMap();
        });
    }

    @Override
    public net.luckperms.api.model.user.User getUser(@NonNull UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uuid");
        return this.proxy((User)((me.lucko.luckperms.common.model.manager.user.UserManager)this.handle).getIfLoaded(uniqueId));
    }

    @Override
    public net.luckperms.api.model.user.User getUser(@NonNull String username) {
        Objects.requireNonNull(username, "name");
        return this.proxy((User)((me.lucko.luckperms.common.model.manager.user.UserManager)this.handle).getByUsername(username));
    }

    @Override
    public @NonNull Set<net.luckperms.api.model.user.User> getLoadedUsers() {
        return (Set)((me.lucko.luckperms.common.model.manager.user.UserManager)this.handle).getAll().values().stream().map(this::proxy).collect(ImmutableCollectors.toSet());
    }

    @Override
    public boolean isLoaded(@NonNull UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uuid");
        return ((me.lucko.luckperms.common.model.manager.user.UserManager)this.handle).isLoaded(uniqueId);
    }

    @Override
    public void cleanupUser(@NonNull net.luckperms.api.model.user.User user) {
        Objects.requireNonNull(user, "user");
        ((me.lucko.luckperms.common.model.manager.user.UserManager)this.handle).getHouseKeeper().clearApiUsage(ApiUser.cast(user).getUniqueId());
    }
}

