/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.backup;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.utils.NodeJsonSerializer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;

public class Importer
implements Runnable {
    private final LuckPermsPlugin plugin;
    private final Set<Sender> notify;
    private final JsonObject data;

    public Importer(LuckPermsPlugin plugin, Sender executor, JsonObject data) {
        this.plugin = plugin;
        this.notify = executor.isConsole() ? ImmutableSet.of((Object)executor) : ImmutableSet.of((Object)executor, (Object)plugin.getConsoleSender());
        this.data = data;
    }

    private void processGroup(String groupName, Set<Node> nodes) {
        Group group = this.plugin.getStorage().createAndLoadGroup(groupName, CreationCause.INTERNAL).join();
        group.setNodes(DataType.NORMAL, nodes);
        this.plugin.getStorage().saveGroup(group);
    }

    private void processTrack(String trackName, List<String> groups) {
        Track track = this.plugin.getStorage().createAndLoadTrack(trackName, CreationCause.INTERNAL).join();
        track.setGroups(groups);
        this.plugin.getStorage().saveTrack(track).join();
    }

    private void processUser(UUID uuid, UserData userData) {
        User user = this.plugin.getStorage().loadUser(uuid, userData.username).join();
        if (userData.primaryGroup != null) {
            user.getPrimaryGroup().setStoredValue(userData.primaryGroup);
        }
        user.setNodes(DataType.NORMAL, userData.nodes);
        this.plugin.getStorage().saveUser(user).join();
        this.plugin.getUserManager().getHouseKeeper().cleanup(user.getUniqueId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        this.notify.forEach(s -> Message.IMPORT_START.send((Sender)s, new Object[0]));
        CompletableFuture<Void> updateTask = CompletableFuture.runAsync(() -> {
            Void cfr_ignored_0 = (Void)this.plugin.getSyncTaskBuffer().requestDirectly();
        });
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "Reading data..."));
        HashMap groups = new HashMap();
        HashMap tracks = new HashMap();
        HashMap<UUID, UserData> users = new HashMap<UUID, UserData>();
        for (Map.Entry group : this.data.get("groups").getAsJsonObject().entrySet()) {
            groups.put(group.getKey(), NodeJsonSerializer.deserializeNodes(((JsonElement)group.getValue()).getAsJsonObject().get("nodes").getAsJsonArray()));
        }
        for (Map.Entry track : this.data.get("tracks").getAsJsonObject().entrySet()) {
            JsonArray trackGroups = ((JsonElement)track.getValue()).getAsJsonObject().get("groups").getAsJsonArray();
            ArrayList trackGroupsList = new ArrayList();
            trackGroups.forEach(g -> trackGroupsList.add(g.getAsString()));
            tracks.put(track.getKey(), trackGroupsList);
        }
        for (Map.Entry user : this.data.get("users").getAsJsonObject().entrySet()) {
            void var12_12;
            JsonObject jsonData = ((JsonElement)user.getValue()).getAsJsonObject();
            UUID uuid = UUID.fromString((String)user.getKey());
            Iterator username = null;
            Object var12_13 = null;
            Set<Node> nodes = NodeJsonSerializer.deserializeNodes(jsonData.get("nodes").getAsJsonArray());
            if (jsonData.has("username")) {
                username = jsonData.get("username").getAsString();
            }
            if (jsonData.has("primaryGroup")) {
                String string = jsonData.get("primaryGroup").getAsString();
            }
            users.put(uuid, new UserData((String)((Object)username), (String)var12_12, nodes));
        }
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "Waiting for initial update task to complete..."));
        updateTask.join();
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "Setting up data processor..."));
        ExecutorService executor = Executors.newFixedThreadPool(16, new ThreadFactoryBuilder().setNameFormat("luckperms-importer-%d").build());
        HashSet<CompletionStage> futures = new HashSet<CompletionStage>();
        int total = 0;
        AtomicInteger processedCount = new AtomicInteger(0);
        for (Map.Entry entry : groups.entrySet()) {
            futures.add(CompletableFuture.completedFuture(entry).thenAcceptAsync(ent -> {
                this.processGroup((String)ent.getKey(), (Set)ent.getValue());
                processedCount.incrementAndGet();
            }, (Executor)executor));
            ++total;
        }
        for (Map.Entry entry : tracks.entrySet()) {
            futures.add(CompletableFuture.completedFuture(entry).thenAcceptAsync(ent -> {
                this.processTrack((String)ent.getKey(), (List)ent.getValue());
                processedCount.incrementAndGet();
            }, (Executor)executor));
            ++total;
        }
        for (Map.Entry entry : users.entrySet()) {
            futures.add(CompletableFuture.completedFuture(entry).thenAcceptAsync(ent -> {
                this.processUser((UUID)ent.getKey(), (UserData)ent.getValue());
                processedCount.incrementAndGet();
            }, (Executor)executor));
            ++total;
        }
        CompletableFuture<Void> overallFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "All data entries have been processed and scheduled for import - now waiting for the execution to complete."));
        while (true) {
            try {
                overallFuture.get(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
            catch (TimeoutException timeoutException) {
                this.sendProgress(processedCount.get(), total);
                continue;
            }
            break;
        }
        executor.shutdown();
        long l = System.currentTimeMillis();
        double seconds = (double)(l - startTime) / 1000.0;
        this.notify.forEach(s -> Message.IMPORT_END_COMPLETE.send((Sender)s, seconds));
    }

    private void sendProgress(int processedCount, int total) {
        int percent = processedCount * 100 / total;
        this.notify.forEach(s -> Message.IMPORT_PROGRESS.send((Sender)s, percent, processedCount, total, 0));
    }

    private static final class UserData {
        private final String username;
        private final String primaryGroup;
        private final Set<Node> nodes;

        UserData(String username, String primaryGroup, Set<Node> nodes) {
            this.username = username;
            this.primaryGroup = primaryGroup;
            this.nodes = nodes;
        }
    }
}

